/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import java.util.List;

public class VerifyImageGallery
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyImageGallery.class);

    protected void doVerify() throws Exception {
        List images = IGImageLocalServiceUtil.getNoAssetImages();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + images.size() + " images with no tags assets"));
        }
        for (IGImage image : images) {
            try {
                IGImageLocalServiceUtil.updateTagsAsset((long)image.getUserId(), (IGImage)image, (String[])new String[0], (String[])new String[0], null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update tags asset for image " + image.getImageId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Tags assets verified for images");
        }
    }
}

