/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;

public class VerifyProcessUtil {
    private static Log _log = LogFactoryUtil.getLog(VerifyProcessUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyProcess(boolean ranUpgradeProcess, boolean verified) throws VerifyException {
        boolean ranVerifyProcess = false;
        int verifyFrequency = GetterUtil.getInteger((String)PropsUtil.get("verify.frequency"));
        if (verifyFrequency == -1 || verifyFrequency == 1 && !verified || ranUpgradeProcess) {
            if (ranUpgradeProcess) {
                PropsUtil.set("index.on.startup", Boolean.TRUE.toString());
            }
            String[] verifyProcessClassNames = PropsUtil.getArray("verify.processes");
            BatchSessionUtil.setEnabled((boolean)true);
            boolean tempIndexReadOnly = SearchEngineUtil.isIndexReadOnly();
            SearchEngineUtil.setIndexReadOnly((boolean)true);
            try {
                for (String verifyProcessClassName : verifyProcessClassNames) {
                    boolean tempRanVerifyProcess = VerifyProcessUtil._verifyProcess(verifyProcessClassName);
                    if (!tempRanVerifyProcess) continue;
                    ranVerifyProcess = true;
                }
            }
            finally {
                BatchSessionUtil.setEnabled((boolean)false);
                SearchEngineUtil.setIndexReadOnly((boolean)tempIndexReadOnly);
            }
        }
        return ranVerifyProcess;
    }

    private static boolean _verifyProcess(String verifyProcessClassName) throws VerifyException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing verification " + verifyProcessClassName));
        }
        try {
            VerifyProcess verifyProcess = (VerifyProcess)Class.forName(verifyProcessClassName).newInstance();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Running verification " + verifyProcessClassName));
            }
            verifyProcess.verify();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Finished verification " + verifyProcessClassName));
            }
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            _log.error((Object)(verifyProcessClassName + " cannot be found"));
        }
        catch (IllegalAccessException iae) {
            _log.error((Object)(verifyProcessClassName + " cannot be accessed"));
        }
        catch (InstantiationException ie) {
            _log.error((Object)(verifyProcessClassName + " cannot be initiated"));
        }
        return false;
    }
}

