/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.util.SystemProperties;

public class VerifyProperties
extends VerifyProcess {
    private static final String[][] _MIGRATED_SYSTEM_KEYS = new String[][]{{"com.liferay.filters.compression.CompressionFilter", "com.liferay.portal.servlet.filters.gzip.GZipFilter"}, {"com.liferay.filters.doubleclick.DoubleClickFilter", "com.liferay.portal.servlet.filters.doubleclick.DoubleClickFilter"}, {"com.liferay.filters.strip.StripFilter", "com.liferay.portal.servlet.filters.strip.StripFilter"}, {"com.liferay.util.Http.max.connections.per.host", "com.liferay.portal.util.HttpImpl.max.connections.per.host"}, {"com.liferay.util.Http.max.total.connections", "com.liferay.portal.util.HttpImpl.max.total.connections"}, {"com.liferay.util.Http.proxy.auth.type", "com.liferay.portal.util.HttpImpl.proxy.auth.type"}, {"com.liferay.util.Http.proxy.ntlm.domain", "com.liferay.portal.util.HttpImpl.proxy.ntlm.domain"}, {"com.liferay.util.Http.proxy.ntlm.host", "com.liferay.portal.util.HttpImpl.proxy.ntlm.host"}, {"com.liferay.util.Http.proxy.password", "com.liferay.portal.util.HttpImpl.proxy.password"}, {"com.liferay.util.Http.proxy.username", "com.liferay.portal.util.HttpImpl.proxy.username"}, {"com.liferay.util.Http.timeout", "com.liferay.portal.util.HttpImpl.timeout"}, {"com.liferay.util.servlet.UploadServletRequest.max.size", "com.liferay.portal.upload.UploadServletRequestImpl.max.size"}, {"com.liferay.util.servlet.UploadServletRequest.temp.dir", "com.liferay.portal.upload.UploadServletRequestImpl.temp.dir"}, {"com.liferay.util.servlet.fileupload.LiferayFileItem.threshold.size", "com.liferay.portal.upload.LiferayFileItem.threshold.size"}, {"com.liferay.util.servlet.fileupload.LiferayInputStream.threshold.size", "com.liferay.portal.upload.LiferayInputStream.threshold.size"}};
    private static final String[] _OBSOLETE_PORTAL_KEYS = new String[]{"auth.max.failures.limit", "auth.simultaneous.logins", "cas.validate.url", "commons.pool.enabled", "webdav.storage.class", "webdav.storage.show.edit.url", "webdav.storage.show.view.url", "webdav.storage.tokens", "xss.allow"};
    private static final String[] _OBSOLETE_SYSTEM_KEYS = new String[]{"com.liferay.util.Http.proxy.host", "com.liferay.util.Http.proxy.port", "com.liferay.util.XSSUtil.regexp.pattern"};
    private static final String[][] _RENAMED_PORTAL_KEYS = new String[][]{{"amazon.license.0", "amazon.access.key.id"}, {"amazon.license.1", "amazon.access.key.id"}, {"amazon.license.2", "amazon.access.key.id"}, {"amazon.license.3", "amazon.access.key.id"}, {"cdn.host", "cdn.host.http"}, {"com.liferay.portal.servlet.filters.compression.CompressionFilter", "com.liferay.portal.servlet.filters.gzip.GZipFilter"}, {"default.guest.friendly.url", "default.guest.public.layout.friendly.url"}, {"default.guest.layout.column", "default.guest.public.layout.column"}, {"default.guest.layout.name", "default.guest.public.layout.name"}, {"default.guest.layout.template.id", "default.guest.public.layout.template.id"}, {"default.user.layout.column", "default.user.public.layout.column"}, {"default.user.layout.name", "default.user.public.layout.name"}, {"default.user.layout.template.id", "default.user.public.layout.template.id"}, {"default.user.private.layout.lar", "default.user.private.layouts.lar"}, {"default.user.public.layout.lar", "default.user.public.layouts.lar"}};
    private static final String[][] _RENAMED_SYSTEM_KEYS = new String[0][];
    private static Log _log = LogFactoryUtil.getLog(VerifyProperties.class);

    protected void doVerify() throws Exception {
        String newKey;
        String oldKey;
        for (String[] stringArray : _MIGRATED_SYSTEM_KEYS) {
            oldKey = stringArray[0];
            newKey = stringArray[1];
            this.verifyMigratedSystemProperty(oldKey, newKey);
        }
        for (String[] stringArray : _RENAMED_SYSTEM_KEYS) {
            oldKey = stringArray[0];
            newKey = stringArray[1];
            this.verifyRenamedSystemProperty(oldKey, newKey);
        }
        for (String[] stringArray : _OBSOLETE_SYSTEM_KEYS) {
            this.verifyObsoleteSystemProperty((String)stringArray);
        }
        for (String[] stringArray : _RENAMED_PORTAL_KEYS) {
            oldKey = stringArray[0];
            newKey = stringArray[1];
            this.verifyRenamedPortalProperty(oldKey, newKey);
        }
        for (String[] stringArray : _OBSOLETE_PORTAL_KEYS) {
            this.verifyObsoletePortalProperty((String)stringArray);
        }
    }

    protected void verifyMigratedSystemProperty(String oldKey, String newKey) throws Exception {
        String value = SystemProperties.get((String)oldKey);
        if (value != null) {
            _log.error((Object)("System property \"" + oldKey + "\" was migrated to the portal property \"" + newKey + "\""));
        }
    }

    protected void verifyRenamedPortalProperty(String oldKey, String newKey) throws Exception {
        String value = PropsUtil.get(oldKey);
        if (value != null) {
            _log.error((Object)("Portal property \"" + oldKey + "\" was renamed to \"" + newKey + "\""));
        }
    }

    protected void verifyRenamedSystemProperty(String oldKey, String newKey) throws Exception {
        String value = SystemProperties.get((String)oldKey);
        if (value != null) {
            _log.error((Object)("System property \"" + oldKey + "\" was renamed to \"" + newKey + "\""));
        }
    }

    protected void verifyObsoletePortalProperty(String key) throws Exception {
        String value = PropsUtil.get(key);
        if (value != null) {
            _log.error((Object)("Portal property \"" + key + "\" is obsolete"));
        }
    }

    protected void verifyObsoleteSystemProperty(String key) throws Exception {
        String value = SystemProperties.get((String)key);
        if (value != null) {
            _log.error((Object)("System property \"" + key + "\" is obsolete"));
        }
    }
}

