/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MethodInvoker;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.imagegallery.service.IGFolderLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFeedLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class VerifyUUID
extends VerifyProcess {
    private static final String[][] _MODELS = new String[][]{{IGFolderLocalServiceUtil.class.getName(), "IGFolder", "folderId"}, {IGImageLocalServiceUtil.class.getName(), "IGImage", "imageId"}, {JournalArticleLocalServiceUtil.class.getName(), "JournalArticle", "id_"}, {JournalFeedLocalServiceUtil.class.getName(), "JournalFeed", "id_"}, {JournalStructureLocalServiceUtil.class.getName(), "JournalStructure", "id_"}, {JournalTemplateLocalServiceUtil.class.getName(), "JournalTemplate", "id_"}};

    protected void doVerify() throws Exception {
        for (String[] model : _MODELS) {
            this.verifyModel(model[0], model[1], model[2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyModel(String serviceClassName, String modelName, String pkColumnName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select " + pkColumnName + " from " + modelName + " where uuid_ is null or uuid_ = ''");
            rs = ps.executeQuery();
            while (rs.next()) {
                long pk = rs.getLong(pkColumnName);
                this.verifyModel(serviceClassName, modelName, pk);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void verifyModel(String serviceClassName, String modelName, long pk) throws Exception {
        Object obj = MethodInvoker.invoke((MethodWrapper)new MethodWrapper(serviceClassName, "get" + modelName, (Object)new LongWrapper(pk)));
        MethodInvoker.invoke((MethodWrapper)new MethodWrapper(serviceClassName, "update" + modelName, obj));
    }
}

