/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.util.List;

public class VerifyWiki
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyWiki.class);

    protected void doVerify() throws Exception {
        List pages = WikiPageLocalServiceUtil.getNoAssetPages();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + pages.size() + " pages with no tags assets"));
        }
        for (WikiPage page : pages) {
            try {
                WikiPageLocalServiceUtil.updateTagsAsset((long)page.getUserId(), (WikiPage)page, (String[])new String[0], (String[])new String[0]);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update tags asset for page " + page.getPageId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Tags assets verified for pages");
        }
    }
}

