/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webcache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePool;

public class WebCachePoolImpl
implements WebCachePool {
    public static final String CACHE_NAME = WebCachePool.class.getName();
    private static Log _log = LogFactoryUtil.getLog(WebCachePoolImpl.class);
    private SingleVMPool _singleVMPool;
    private PortalCache _cache;

    public void afterPropertiesSet() {
        this._cache = this._singleVMPool.getCache(CACHE_NAME);
    }

    public void clear() {
        this._cache.removeAll();
    }

    public Object get(String key, WebCacheItem wci) {
        Object obj;
        block4: {
            obj = this._cache.get(key);
            if (obj == null) {
                try {
                    obj = wci.convert(key);
                    int timeToLive = (int)(wci.getRefreshTime() / 1000L);
                    this._cache.put(key, obj, timeToLive);
                }
                catch (WebCacheException wce) {
                    if (!_log.isWarnEnabled()) break block4;
                    Throwable cause = wce.getCause();
                    if (cause != null) {
                        _log.warn((Object)cause, cause);
                    }
                    _log.warn((Object)wce, (Throwable)wce);
                }
            }
        }
        return obj;
    }

    public void remove(String key) {
        this._cache.remove(key);
    }

    public void setSingleVMPool(SingleVMPool singleVMPool) {
        this._singleVMPool = singleVMPool;
    }
}

