/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.webdav.BaseResourceImpl;
import com.liferay.portal.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.webdav.Resource;
import com.liferay.portal.webdav.WebDAVException;
import com.liferay.portal.webdav.WebDAVRequest;
import com.liferay.portal.webdav.WebDAVUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    public Resource getResource(WebDAVRequest webDavRequest) throws WebDAVException {
        String path = this.getRootPath() + webDavRequest.getPath();
        return new BaseResourceImpl(path, "", WebDAVUtil.getWebId((String)path));
    }

    public List<Resource> getResources(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
            groupParams.put("usersGroups", new Long(webDavRequest.getUserId()));
            ArrayList<Resource> resources = new ArrayList<Resource>();
            List groups = GroupLocalServiceUtil.search((long)webDavRequest.getCompanyId(), null, null, groupParams, (int)-1, (int)-1);
            for (Group group : groups) {
                Resource resource = this.getResource(group);
                resources.add(resource);
            }
            Group group = GroupLocalServiceUtil.getUserGroup((long)webDavRequest.getCompanyId(), (long)webDavRequest.getUserId());
            Resource resource = this.getResource(group);
            resources.add(resource);
            return resources;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    protected Resource getResource(Group group) throws WebDAVException {
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById((long)group.getCompanyId());
            String webId = company.getWebId();
            String parentPath = this.getRootPath() + "/" + webId;
            String name = group.getFriendlyURL();
            name = name.substring(1, name.length());
            return new BaseResourceImpl(parentPath, name, name);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }
}

