/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.webdav.WebDAVException;
import com.liferay.portal.webdav.WebDAVRequest;
import com.liferay.portal.webdav.WebDAVStorage;
import com.liferay.portal.webdav.WebDAVUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebDAVRequestImpl
implements WebDAVRequest {
    private WebDAVStorage _storage;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private String _userAgent;
    private String _path = "";
    private long _companyId;
    private long _groupId;
    private long _userId;
    private String _lockUuid;
    private PermissionChecker _permissionChecker;

    public WebDAVRequestImpl(WebDAVStorage storage, HttpServletRequest request, HttpServletResponse response, String userAgent, PermissionChecker permissionChecker) throws WebDAVException {
        this._storage = storage;
        this._request = request;
        this._response = response;
        this._userAgent = userAgent;
        this._lockUuid = WebDAVUtil.getLockUuid((HttpServletRequest)request);
        this._path = WebDAVUtil.fixPath((String)this._request.getPathInfo());
        this._companyId = WebDAVUtil.getCompanyId((String)this._path);
        this._groupId = WebDAVUtil.getGroupId((String)this._path);
        this._userId = GetterUtil.getLong((String)this._request.getRemoteUser());
        this._permissionChecker = permissionChecker;
    }

    public WebDAVStorage getWebDAVStorage() {
        return this._storage;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this._response;
    }

    public String getRootPath() {
        return this._storage.getRootPath();
    }

    public String getPath() {
        return this._path;
    }

    public String[] getPathArray() {
        return WebDAVUtil.getPathArray((String)this._path);
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public long getUserId() {
        return this._userId;
    }

    public String getLockUuid() {
        return this._lockUuid;
    }

    public PermissionChecker getPermissionChecker() {
        return this._permissionChecker;
    }

    public boolean isLitmus() {
        return this._userAgent.contains("litmus");
    }

    public boolean isMac() {
        return this._userAgent.contains("WebDAVFS");
    }

    public boolean isWindows() {
        return this._userAgent.contains("Microsoft Data Access Internet Publishing Provider");
    }
}

