/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webdav.CompanyWebDAVStorageImpl;
import com.liferay.portal.webdav.GroupWebDAVStorageImpl;
import com.liferay.portal.webdav.WebDAVException;
import com.liferay.portal.webdav.WebDAVRequestImpl;
import com.liferay.portal.webdav.WebDAVStorage;
import com.liferay.portal.webdav.WebDAVUtil;
import com.liferay.portal.webdav.methods.Method;
import com.liferay.portal.webdav.methods.MethodFactory;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebDAVServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(WebDAVServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) {
        int status = 412;
        String userAgent = request.getHeader("User-Agent");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("User agent " + userAgent));
        }
        try {
            if (this.isIgnoredResource(request)) {
                status = 404;
                return;
            }
            WebDAVStorage storage = this.getStorage(request);
            if (storage.getRootPath() == null) {
                storage.setRootPath(this.getRootPath(request));
            }
            PermissionChecker permissionChecker = null;
            String remoteUser = request.getRemoteUser();
            if (remoteUser != null) {
                PrincipalThreadLocal.setName((String)remoteUser);
                long userId = GetterUtil.getLong((String)remoteUser);
                User user = UserLocalServiceUtil.getUserById((long)userId);
                permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)true);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            }
            Method method = MethodFactory.create(request);
            WebDAVRequestImpl webDavRequest = new WebDAVRequestImpl(storage, request, response, userAgent, permissionChecker);
            status = method.process(webDavRequest);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        finally {
            response.setStatus(status);
            if (_log.isInfoEnabled()) {
                _log.info((Object)(request.getMethod() + " " + request.getRequestURI() + " " + status));
            }
        }
    }

    protected String getRootPath(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(WebDAVUtil.fixPath((String)request.getContextPath()));
        sb.append(WebDAVUtil.fixPath((String)request.getServletPath()));
        return sb.toString();
    }

    protected WebDAVStorage getStorage(HttpServletRequest request) throws WebDAVException {
        String[] pathArray = WebDAVUtil.getPathArray((String)request.getPathInfo(), (boolean)true);
        WebDAVStorage storage = null;
        if (pathArray.length == 1) {
            storage = (WebDAVStorage)InstancePool.get((String)CompanyWebDAVStorageImpl.class.getName());
        } else if (pathArray.length == 2) {
            storage = (WebDAVStorage)InstancePool.get((String)GroupWebDAVStorageImpl.class.getName());
        } else if (pathArray.length >= 3) {
            storage = WebDAVUtil.getStorage((String)pathArray[2]);
        }
        if (storage == null) {
            throw new WebDAVException("Invalid WebDAV path " + request.getPathInfo());
        }
        return storage;
    }

    protected boolean isIgnoredResource(HttpServletRequest request) {
        String[] pathArray = WebDAVUtil.getPathArray((String)request.getPathInfo(), (boolean)true);
        if (pathArray == null || pathArray.length <= 0) {
            return true;
        }
        String resourceName = pathArray[pathArray.length - 1];
        for (String ignore : PropsValues.WEBDAV_IGNORE) {
            if (!ignore.equals(resourceName)) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping over " + request.getMethod() + " " + request.getPathInfo()));
            }
            return true;
        }
        return false;
    }
}

