/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.WebDAVProps;
import com.liferay.portal.service.WebDAVPropsLocalServiceUtil;
import com.liferay.portal.webdav.Resource;
import com.liferay.portal.webdav.WebDAVRequest;
import com.liferay.portal.webdav.WebDAVStorage;
import com.liferay.portal.webdav.WebDAVUtil;
import com.liferay.portal.webdav.methods.Method;
import com.liferay.util.servlet.ServletResponseUtil;
import com.liferay.util.xml.DocUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePropMethodImpl
implements Method {
    private static final String _ALLPROPS = "allprops";
    private static final String _CREATIONDATE = "creationdate";
    private static final String _DISPLAYNAME = "displayname";
    private static final String _GETLASTMODIFIED = "getlastmodified";
    private static final String _GETCONTENTTYPE = "getcontenttype";
    private static final String _GETCONTENTLENGTH = "getcontentlength";
    private static final String _RESOURCETYPE = "resourcetype";
    private static final Tuple _ALL_PROPS_PAIR = new Tuple((Object)"allprops", (Object)WebDAVUtil.DAV_URI);
    private static final Tuple _CREATIONDATE_PAIR = new Tuple((Object)"creationdate", (Object)WebDAVUtil.DAV_URI);
    private static final Tuple _DISPLAYNAME_PAIR = new Tuple((Object)"displayname", (Object)WebDAVUtil.DAV_URI);
    private static final Tuple _GETLASTMODIFIED_PAIR = new Tuple((Object)"getcontentlength", (Object)WebDAVUtil.DAV_URI);
    private static final Tuple _GETCONTENTTYPE_PAIR = new Tuple((Object)"getcontenttype", (Object)WebDAVUtil.DAV_URI);
    private static final Tuple _GETCONTENTLENGTH_PAIR = new Tuple((Object)"getlastmodified", (Object)WebDAVUtil.DAV_URI);
    private static final Tuple _RESOURCETYPE_PAIR = new Tuple((Object)"resourcetype", (Object)WebDAVUtil.DAV_URI);
    private final List<Tuple> _ALL_COLLECTION_PROPS = Arrays.asList(_CREATIONDATE_PAIR, _DISPLAYNAME_PAIR, _GETLASTMODIFIED_PAIR, _GETCONTENTTYPE_PAIR, _RESOURCETYPE_PAIR);
    private final List<Tuple> _ALL_SIMPLE_PROPS = Arrays.asList(_CREATIONDATE_PAIR, _DISPLAYNAME_PAIR, _GETLASTMODIFIED_PAIR, _GETCONTENTTYPE_PAIR, _GETCONTENTLENGTH_PAIR, _RESOURCETYPE_PAIR);
    private static Log _log = LogFactoryUtil.getLog(BasePropMethodImpl.class);

    protected void addResponse(WebDAVStorage storage, WebDAVRequest webDavRequest, Resource resource2, Set<Tuple> props, Element multistatus, long depth) throws Exception {
        this.addResponse(webDavRequest, resource2, props, multistatus);
        if (resource2.isCollection() && depth != 0L) {
            for (Resource resource2 : storage.getResources(webDavRequest)) {
                this.addResponse(webDavRequest, resource2, props, multistatus);
            }
        }
    }

    protected void addResponse(WebDAVRequest webDavRequest, Resource resource, Set<Tuple> props, Element multistatus) throws Exception {
        props = new HashSet<Tuple>(props);
        Element response = DocUtil.add((Element)multistatus, (String)"response", (Namespace)WebDAVUtil.DAV_URI);
        DocUtil.add((Element)response, (String)"href", (Namespace)WebDAVUtil.DAV_URI, (String)resource.getHREF());
        Element successStat = DocUtil.add((Element)response, (String)"propstat", (Namespace)WebDAVUtil.DAV_URI);
        Element successProp = DocUtil.add((Element)successStat, (String)"prop", (Namespace)WebDAVUtil.DAV_URI);
        Element failureStat = DocUtil.add((Element)response, (String)"propstat", (Namespace)WebDAVUtil.DAV_URI);
        Element failureProp = DocUtil.add((Element)failureStat, (String)"prop", (Namespace)WebDAVUtil.DAV_URI);
        boolean hasSuccess = false;
        boolean hasFailure = false;
        if (props.contains(_ALL_PROPS_PAIR)) {
            props.remove(_ALL_PROPS_PAIR);
            if (resource.isCollection()) {
                props.addAll(this._ALL_COLLECTION_PROPS);
            } else {
                props.addAll(this._ALL_SIMPLE_PROPS);
            }
        }
        if (props.contains(_CREATIONDATE_PAIR)) {
            props.remove(_CREATIONDATE_PAIR);
            DocUtil.add((Element)successProp, (String)_CREATIONDATE, (Namespace)WebDAVUtil.DAV_URI, (String)resource.getCreateDate());
            hasSuccess = true;
        }
        if (props.contains(_DISPLAYNAME_PAIR)) {
            props.remove(_DISPLAYNAME_PAIR);
            DocUtil.add((Element)successProp, (String)_DISPLAYNAME, (Namespace)WebDAVUtil.DAV_URI, (String)resource.getDisplayName());
            hasSuccess = true;
        }
        if (props.contains(_GETLASTMODIFIED_PAIR)) {
            props.remove(_GETLASTMODIFIED_PAIR);
            DocUtil.add((Element)successProp, (String)_GETLASTMODIFIED, (Namespace)WebDAVUtil.DAV_URI, (String)resource.getModifiedDate());
            hasSuccess = true;
        }
        if (props.contains(_GETCONTENTTYPE_PAIR)) {
            props.remove(_GETCONTENTTYPE_PAIR);
            DocUtil.add((Element)successProp, (String)_GETCONTENTTYPE, (Namespace)WebDAVUtil.DAV_URI, (String)resource.getContentType());
            hasSuccess = true;
        }
        if (props.contains(_GETCONTENTLENGTH_PAIR)) {
            props.remove(_GETCONTENTLENGTH_PAIR);
            if (!resource.isCollection()) {
                DocUtil.add((Element)successProp, (String)_GETCONTENTLENGTH, (Namespace)WebDAVUtil.DAV_URI, (int)resource.getSize());
                hasSuccess = true;
            } else {
                DocUtil.add((Element)failureProp, (String)_GETCONTENTLENGTH, (Namespace)WebDAVUtil.DAV_URI);
                hasFailure = true;
            }
        }
        if (props.contains(_RESOURCETYPE_PAIR)) {
            props.remove(_RESOURCETYPE_PAIR);
            Element resourceType = DocUtil.add((Element)successProp, (String)_RESOURCETYPE, (Namespace)WebDAVUtil.DAV_URI);
            if (resource.isCollection()) {
                DocUtil.add((Element)resourceType, (String)"collection", (Namespace)WebDAVUtil.DAV_URI);
            }
            hasSuccess = true;
        }
        WebDAVProps webDavProps = WebDAVPropsLocalServiceUtil.getWebDAVProps((long)webDavRequest.getCompanyId(), (String)resource.getClassName(), (long)resource.getPrimaryKey());
        Set customProps = webDavProps.getPropsSet();
        for (Tuple tuple : props) {
            String name = (String)tuple.getObject(0);
            Namespace namespace = (Namespace)tuple.getObject(1);
            String prefix = namespace.getPrefix();
            String uri = namespace.getURI();
            if (customProps.contains(tuple)) {
                String text = webDavProps.getText(name, prefix, uri);
                DocUtil.add((Element)successProp, (String)name, (Namespace)namespace, (String)text);
                hasSuccess = true;
                continue;
            }
            DocUtil.add((Element)failureProp, (String)name, (Namespace)namespace);
            hasFailure = true;
        }
        if (hasSuccess) {
            DocUtil.add((Element)successStat, (String)"status", (Namespace)WebDAVUtil.DAV_URI, (String)"HTTP/1.1 200 OK");
        } else {
            response.remove(successStat);
        }
        if (!hasSuccess && hasFailure) {
            DocUtil.add((Element)failureStat, (String)"status", (Namespace)WebDAVUtil.DAV_URI, (String)"HTTP/1.1 404 Not Found");
        } else {
            response.remove(failureStat);
        }
    }

    protected void addResponse(String href, Element multistatus) throws Exception {
        Element response = DocUtil.add((Element)multistatus, (String)"response", (Namespace)WebDAVUtil.DAV_URI);
        DocUtil.add((Element)response, (String)"href", (Namespace)WebDAVUtil.DAV_URI, (String)href);
        Element propstat = DocUtil.add((Element)response, (String)"propstat", (Namespace)WebDAVUtil.DAV_URI);
        DocUtil.add((Element)propstat, (String)"status", (Namespace)WebDAVUtil.DAV_URI, (String)"HTTP/1.1 404 Not Found");
    }

    protected int writeResponseXML(WebDAVRequest webDavRequest, Set<Tuple> props) throws Exception {
        WebDAVStorage storage = webDavRequest.getWebDAVStorage();
        long depth = WebDAVUtil.getDepth((HttpServletRequest)webDavRequest.getHttpServletRequest());
        Document doc = SAXReaderUtil.createDocument();
        Element multistatus = SAXReaderUtil.createElement((QName)SAXReaderUtil.createQName((String)"multistatus", (Namespace)WebDAVUtil.DAV_URI));
        doc.setRootElement(multistatus);
        Resource resource = storage.getResource(webDavRequest);
        if (resource != null) {
            int status;
            block5: {
                this.addResponse(storage, webDavRequest, resource, props, multistatus, depth);
                String xml = doc.formattedString("    ");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Response XML\n" + xml));
                }
                status = 207;
                HttpServletResponse response = webDavRequest.getHttpServletResponse();
                response.setContentType("text/xml; charset=UTF-8");
                response.setStatus(status);
                try {
                    ServletResponseUtil.write((HttpServletResponse)response, (String)xml);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Throwable)e);
                }
            }
            return status;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("No resource found for " + storage.getRootPath() + webDavRequest.getPath()));
        }
        return 404;
    }
}

