/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.webdav.Resource;
import com.liferay.portal.webdav.WebDAVException;
import com.liferay.portal.webdav.WebDAVRequest;
import com.liferay.portal.webdav.WebDAVStorage;
import com.liferay.portal.webdav.WebDAVUtil;
import com.liferay.portal.webdav.methods.Method;
import javax.servlet.http.HttpServletRequest;

public class CopyMethodImpl
implements Method {
    private static Log _log = LogFactoryUtil.getLog(CopyMethodImpl.class);

    public int process(WebDAVRequest webDavRequest) throws WebDAVException {
        WebDAVStorage storage = webDavRequest.getWebDAVStorage();
        HttpServletRequest request = webDavRequest.getHttpServletRequest();
        String destination = WebDAVUtil.getDestination((HttpServletRequest)request, (String)storage.getRootPath());
        StringBuilder sb = new StringBuilder();
        if (_log.isInfoEnabled()) {
            sb.append("Destination is " + destination);
        }
        int status = 403;
        if (!destination.equals(webDavRequest.getPath()) && WebDAVUtil.getGroupId((String)destination) == webDavRequest.getGroupId()) {
            Resource resource = storage.getResource(webDavRequest);
            if (resource == null) {
                status = 404;
            } else if (resource.isCollection()) {
                boolean overwrite = WebDAVUtil.isOverwrite((HttpServletRequest)request);
                long depth = WebDAVUtil.getDepth((HttpServletRequest)request);
                if (_log.isInfoEnabled()) {
                    sb.append(", overwrite is " + overwrite);
                    sb.append(", depth is " + depth);
                    _log.info((Object)sb.toString());
                }
                status = storage.copyCollectionResource(webDavRequest, resource, destination, overwrite, depth);
            } else {
                boolean overwrite = WebDAVUtil.isOverwrite((HttpServletRequest)request);
                if (_log.isInfoEnabled()) {
                    sb.append(", overwrite is " + overwrite);
                    _log.info((Object)sb.toString());
                }
                status = storage.copySimpleResource(webDavRequest, resource, destination, overwrite);
            }
        }
        return status;
    }
}

