/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.zip;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipReader;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.zip.ZipDriver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipReaderImpl
implements ZipReader {
    private static Log _log;
    private de.schlichtherle.io.File _zipFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipReaderImpl(InputStream inputStream) throws IOException {
        this._zipFile = new de.schlichtherle.io.File(FileUtil.createTempFile((String)"zip"));
        FileOutputStream outputStream = new FileOutputStream((File)this._zipFile);
        try {
            de.schlichtherle.io.File.cat((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    public ZipReaderImpl(File file) {
        this._zipFile = new de.schlichtherle.io.File(file);
    }

    public void close() {
        this._zipFile.delete();
    }

    public List<String> getEntries() {
        de.schlichtherle.io.File[] files;
        ArrayList<String> folderEntries = new ArrayList<String>();
        for (de.schlichtherle.io.File file : files = (de.schlichtherle.io.File[])this._zipFile.listFiles()) {
            if (!file.isDirectory()) {
                folderEntries.add(file.getEnclEntryName());
                continue;
            }
            this.processDirectory(file, folderEntries);
        }
        return folderEntries;
    }

    public byte[] getEntryAsByteArray(String name) {
        if (Validator.isNull((String)name)) {
            return null;
        }
        byte[] bytes = null;
        try {
            InputStream is = this.getEntryAsInputStream(name);
            if (is != null) {
                bytes = FileUtil.getBytes((InputStream)is);
            }
        }
        catch (IOException e) {
            _log.error((Object)e, (Throwable)e);
        }
        return bytes;
    }

    public InputStream getEntryAsInputStream(String name) {
        de.schlichtherle.io.File file;
        if (Validator.isNull((String)name)) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((file = new de.schlichtherle.io.File((File)this._zipFile, name, (ArchiveDetector)DefaultArchiveDetector.NULL)).exists() && !file.isDirectory()) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Extracting " + name));
                }
                return new FileInputStream((File)file);
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return null;
    }

    public String getEntryAsString(String name) {
        if (Validator.isNull((String)name)) {
            return null;
        }
        byte[] bytes = this.getEntryAsByteArray(name);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public List<String> getFolderEntries(String path) {
        de.schlichtherle.io.File[] files;
        if (Validator.isNull((String)path)) {
            return null;
        }
        ArrayList<String> folderEntries = new ArrayList<String>();
        de.schlichtherle.io.File directory = new de.schlichtherle.io.File(this._zipFile.getPath() + "/" + path);
        for (de.schlichtherle.io.File file : files = (de.schlichtherle.io.File[])directory.listFiles()) {
            if (file.isDirectory()) continue;
            folderEntries.add(file.getEnclEntryName());
        }
        return folderEntries;
    }

    protected void processDirectory(de.schlichtherle.io.File directory, List<String> folderEntries) {
        de.schlichtherle.io.File[] files;
        for (de.schlichtherle.io.File file : files = (de.schlichtherle.io.File[])directory.listFiles()) {
            if (!file.isDirectory()) {
                folderEntries.add(file.getEnclEntryName());
                continue;
            }
            this.processDirectory(file, folderEntries);
        }
    }

    static {
        de.schlichtherle.io.File.setDefaultArchiveDetector((ArchiveDetector)new DefaultArchiveDetector(DefaultArchiveDetector.DEFAULT, "lar|war|zip", (ArchiveDriver)new ZipDriver()));
        _log = LogFactoryUtil.getLog(ZipReaderImpl.class);
    }
}

