/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.zip;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.util.SystemProperties;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.zip.ZipDriver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZipWriterImpl
implements ZipWriter {
    private static final Log _log;
    private final de.schlichtherle.io.File _file;

    public ZipWriterImpl() {
        this._file = new de.schlichtherle.io.File(SystemProperties.get((String)"java.io.tmpdir") + "/" + PortalUUIDUtil.generate() + ".zip");
        this._file.mkdir();
        this._file.deleteOnExit();
    }

    public ZipWriterImpl(File file) {
        this._file = new de.schlichtherle.io.File(file);
        this._file.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String name, byte[] bytes) throws IOException {
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(bytes);
        try {
            this.addEntry(name, (InputStream)unsyncByteArrayInputStream);
        }
        finally {
            unsyncByteArrayInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String name, InputStream inpuStream) throws IOException {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (inpuStream == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding " + name));
        }
        FileUtil.mkdirs((String)this.getPath());
        FileOutputStream outputStream = new FileOutputStream((File)new de.schlichtherle.io.File(this.getPath() + "/" + name));
        try {
            de.schlichtherle.io.File.cat((InputStream)inpuStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    public void addEntry(String name, String s) throws IOException {
        this.addEntry(name, s.getBytes("UTF-8"));
    }

    public void addEntry(String name, StringBuilder sb) throws IOException {
        this.addEntry(name, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] finish() throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        FileInputStream inputStream = new FileInputStream((File)this._file);
        try {
            de.schlichtherle.io.File.cat((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream);
        }
        finally {
            unsyncByteArrayOutputStream.close();
            inputStream.close();
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public File getFile() {
        try {
            de.schlichtherle.io.File.umount((de.schlichtherle.io.File)this._file);
        }
        catch (ArchiveException ae) {
            _log.error((Object)ae, (Throwable)ae);
        }
        return this._file;
    }

    public String getPath() {
        return this._file.getPath();
    }

    static {
        de.schlichtherle.io.File.setDefaultArchiveDetector((ArchiveDetector)new DefaultArchiveDetector(DefaultArchiveDetector.DEFAULT, "lar", (ArchiveDriver)new ZipDriver()));
        _log = LogFactoryUtil.getLog(ZipWriter.class);
    }
}

