/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.model.Portlet;
import com.liferay.portlet.PortletConfigImpl;
import com.liferay.portlet.PortletContextFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

public class PortletConfigFactory {
    private static PortletConfigFactory _instance = new PortletConfigFactory();
    private Map<String, Map<String, PortletConfig>> _pool = new ConcurrentHashMap<String, Map<String, PortletConfig>>();

    public static PortletConfig create(Portlet portlet, ServletContext servletContext) {
        return _instance._create(portlet, servletContext);
    }

    public static void destroy(Portlet portlet) {
        _instance._destroy(portlet);
    }

    private PortletConfigFactory() {
    }

    private PortletConfig _create(Portlet portlet, ServletContext servletContext) {
        PortletConfig portletConfig;
        Map<String, PortletConfig> portletConfigs = this._pool.get(portlet.getRootPortletId());
        if (portletConfigs == null) {
            portletConfigs = new ConcurrentHashMap<String, PortletConfig>();
            this._pool.put(portlet.getRootPortletId(), portletConfigs);
        }
        if ((portletConfig = portletConfigs.get(portlet.getPortletId())) == null) {
            PortletContext portletContext = PortletContextFactory.create(portlet, servletContext);
            portletConfig = new PortletConfigImpl(portlet, portletContext);
            portletConfigs.put(portlet.getPortletId(), portletConfig);
        }
        return portletConfig;
    }

    private void _destroy(Portlet portlet) {
        this._pool.remove(portlet.getRootPortletId());
    }
}

