/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletInfo;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portlet.PortletResourceBundle;
import com.liferay.portlet.StrutsResourceBundle;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletConfigImpl
implements PortletConfig {
    public static final String RUNTIME_OPTION_ESCAPE_XML = "javax.portlet.escapeXml";
    public static final String RUNTIME_OPTION_PORTAL_CONTEXT = "com.liferay.portal.portalContext";
    private static Log _log = LogFactoryUtil.getLog(PortletConfigImpl.class);
    private PortletApp _portletApp;
    private Portlet _portlet;
    private String _portletName;
    private PortletContext _portletContext;
    private Map<String, ResourceBundle> _bundlePool;

    public PortletConfigImpl(Portlet portlet, PortletContext portletContext) {
        this._portletApp = portlet.getPortletApp();
        this._portlet = portlet;
        this._portletName = portlet.getRootPortletId();
        int pos = this._portletName.indexOf("_WAR_");
        if (pos != -1) {
            this._portletName = this._portletName.substring(0, pos);
        }
        this._portletContext = portletContext;
        this._bundlePool = new HashMap<String, ResourceBundle>();
    }

    public Map<String, String[]> getContainerRuntimeOptions() {
        return this._portletApp.getContainerRuntimeOptions();
    }

    public String getDefaultNamespace() {
        return this._portletApp.getDefaultNamespace();
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return (String)this._portlet.getInitParams().get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this._portlet.getInitParams().keySet());
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public String getPortletId() {
        return this._portlet.getPortletId();
    }

    public String getPortletName() {
        return this._portletName;
    }

    public Enumeration<QName> getProcessingEventQNames() {
        return Collections.enumeration(this.toJavaxQNames(this._portlet.getProcessingEvents()));
    }

    public Enumeration<String> getPublicRenderParameterNames() {
        ArrayList<String> publicRenderParameterNames = new ArrayList<String>();
        for (PublicRenderParameter publicRenderParameter : this._portlet.getPublicRenderParameters()) {
            publicRenderParameterNames.add(publicRenderParameter.getIdentifier());
        }
        return Collections.enumeration(publicRenderParameterNames);
    }

    public Enumeration<QName> getPublishingEventQNames() {
        return Collections.enumeration(this.toJavaxQNames(this._portlet.getPublishingEvents()));
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        String resourceBundleClassName = this._portlet.getResourceBundle();
        if (Validator.isNull((String)resourceBundleClassName)) {
            String poolId = this._portlet.getPortletId();
            ResourceBundle bundle = this._bundlePool.get(poolId);
            if (bundle == null) {
                StringBuilder sb = new StringBuilder();
                try {
                    PortletInfo portletInfo = this._portlet.getPortletInfo();
                    sb.append("javax.portlet.title");
                    sb.append("=");
                    sb.append(portletInfo.getTitle());
                    sb.append("\n");
                    sb.append("javax.portlet.short-title");
                    sb.append("=");
                    sb.append(portletInfo.getShortTitle());
                    sb.append("\n");
                    sb.append("javax.portlet.keywords");
                    sb.append("=");
                    sb.append(portletInfo.getKeywords());
                    sb.append("\n");
                    sb.append("javax.portlet.description");
                    sb.append("=");
                    sb.append(portletInfo.getDescription());
                    sb.append("\n");
                    bundle = new PropertyResourceBundle((InputStream)new UnsyncByteArrayInputStream(sb.toString().getBytes()));
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
                this._bundlePool.put(poolId, bundle);
            }
            return bundle;
        }
        String poolId = this._portlet.getPortletId() + "." + locale.toString();
        ResourceBundle bundle = this._bundlePool.get(poolId);
        if (bundle == null) {
            if (!this._portletApp.isWARFile() && resourceBundleClassName.equals(StrutsResourceBundle.class.getName())) {
                bundle = new StrutsResourceBundle(this._portletName, locale);
            } else {
                PortletBag portletBag = PortletBagPool.get((String)this._portlet.getRootPortletId());
                bundle = portletBag.getResourceBundle(locale);
            }
            bundle = new PortletResourceBundle(bundle, this._portlet.getPortletInfo());
            this._bundlePool.put(poolId, bundle);
        }
        return bundle;
    }

    public Enumeration<Locale> getSupportedLocales() {
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        for (String languageId : this._portlet.getSupportedLocales()) {
            supportedLocales.add(LocaleUtil.fromLanguageId((String)languageId));
        }
        return Collections.enumeration(supportedLocales);
    }

    public boolean isWARFile() {
        return this._portletApp.isWARFile();
    }

    protected Set<QName> toJavaxQNames(Set<com.liferay.portal.kernel.xml.QName> liferayQNames) {
        HashSet<QName> javaxQNames = new HashSet<QName>(liferayQNames.size());
        for (com.liferay.portal.kernel.xml.QName liferayQName : liferayQNames) {
            QName javaxQName = new QName(liferayQName.getNamespaceURI(), liferayQName.getLocalPart(), liferayQName.getNamespacePrefix());
            javaxQNames.add(javaxQName);
        }
        return javaxQNames;
    }
}

