/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.PortletConfigFactory;
import com.liferay.portlet.PortletContextFactory;
import com.liferay.portlet.PortletInstanceFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.UnavailableException;
import javax.servlet.ServletContext;

public class PortletInstanceFactoryImpl
implements PortletInstanceFactory {
    private InvokerPortlet _internalInvokerPortletPrototype;
    private Map<String, Map<String, InvokerPortlet>> _pool = new ConcurrentHashMap<String, Map<String, InvokerPortlet>>();

    public void clear(Portlet portlet) {
        PortletBag portletBag;
        Map<String, InvokerPortlet> portletInstances = this._pool.get(portlet.getRootPortletId());
        if (portletInstances != null) {
            for (Map.Entry<String, InvokerPortlet> entry : portletInstances.entrySet()) {
                String portletId = entry.getKey();
                InvokerPortlet invokerPortletInstance = entry.getValue();
                if (PortletConstants.getInstanceId((String)portletId) != null) continue;
                invokerPortletInstance.destroy();
                break;
            }
        }
        this._pool.remove(portlet.getRootPortletId());
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp.isWARFile() && (portletBag = PortletBagPool.get((String)portlet.getRootPortletId())) != null) {
            portletBag.setPortletInstance(null);
        }
    }

    public InvokerPortlet create(Portlet portlet, ServletContext servletContext) throws PortletException {
        Map<String, InvokerPortlet> portletInstances;
        boolean instanceable = false;
        if (portlet.isInstanceable() && PortletConstants.getInstanceId((String)portlet.getPortletId()) != null) {
            instanceable = true;
        }
        if ((portletInstances = this._pool.get(portlet.getRootPortletId())) == null) {
            portletInstances = new ConcurrentHashMap<String, InvokerPortlet>();
            this._pool.put(portlet.getRootPortletId(), portletInstances);
        }
        InvokerPortlet instanceInvokerPortletInstance = null;
        if (instanceable) {
            instanceInvokerPortletInstance = portletInstances.get(portlet.getPortletId());
        }
        InvokerPortlet rootInvokerPortletInstance = null;
        if (instanceInvokerPortletInstance == null && (rootInvokerPortletInstance = portletInstances.get(portlet.getRootPortletId())) == null) {
            PortletConfig portletConfig = PortletConfigFactory.create(portlet, servletContext);
            PortletApp portletApp = portlet.getPortletApp();
            if (portletApp.isWARFile()) {
                PortletBag portletBag = PortletBagPool.get((String)portlet.getRootPortletId());
                rootInvokerPortletInstance = this.init(portlet, portletConfig, portletBag.getPortletInstance());
            } else {
                rootInvokerPortletInstance = this.init(portlet, portletConfig);
            }
            portletInstances.put(portlet.getRootPortletId(), rootInvokerPortletInstance);
        }
        if (instanceable) {
            if (instanceInvokerPortletInstance == null) {
                javax.portlet.Portlet portletInstance = rootInvokerPortletInstance.getPortletInstance();
                PortletConfig portletConfig = PortletConfigFactory.create(portlet, servletContext);
                PortletContext portletContext = portletConfig.getPortletContext();
                boolean facesPortlet = rootInvokerPortletInstance.isFacesPortlet();
                boolean strutsPortlet = rootInvokerPortletInstance.isStrutsPortlet();
                boolean strutsBridgePortlet = rootInvokerPortletInstance.isStrutsBridgePortlet();
                instanceInvokerPortletInstance = this._internalInvokerPortletPrototype.create(portlet, portletInstance, portletConfig, portletContext, facesPortlet, strutsPortlet, strutsBridgePortlet);
                portletInstances.put(portlet.getPortletId(), instanceInvokerPortletInstance);
            }
        } else if (rootInvokerPortletInstance != null) {
            instanceInvokerPortletInstance = rootInvokerPortletInstance;
        }
        return instanceInvokerPortletInstance;
    }

    public void destroy(Portlet portlet) {
        this.clear(portlet);
        PortletConfigFactory.destroy(portlet);
        PortletContextFactory.destroy(portlet);
        PortletLocalServiceUtil.destroyPortlet((Portlet)portlet);
    }

    public void setInternalInvokerPortletPrototype(InvokerPortlet internalInvokerPortletPrototype) {
        this._internalInvokerPortletPrototype = internalInvokerPortletPrototype;
    }

    protected InvokerPortlet init(Portlet portlet, PortletConfig portletConfig) throws PortletException {
        return this.init(portlet, portletConfig, null);
    }

    protected InvokerPortlet init(Portlet portlet, PortletConfig portletConfig, javax.portlet.Portlet portletInstance) throws PortletException {
        InvokerPortlet invokerPortlet = null;
        try {
            if (portletInstance == null) {
                portletInstance = (javax.portlet.Portlet)Class.forName(portlet.getPortletClass()).newInstance();
            }
            PortletContext portletContext = portletConfig.getPortletContext();
            invokerPortlet = this._internalInvokerPortletPrototype.create(portlet, portletInstance, portletContext);
            invokerPortlet.init(portletConfig);
        }
        catch (ClassNotFoundException cnofe) {
            throw new UnavailableException(cnofe.getMessage());
        }
        catch (InstantiationException ie) {
            throw new UnavailableException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new UnavailableException(iae.getMessage());
        }
        return invokerPortlet;
    }
}

