/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.Preference;
import com.liferay.util.xml.XMLFormatter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPreferencesImpl
implements Cloneable,
PortletPreferences,
Serializable {
    private static final String _NULL_VALUE = "NULL_VALUE";
    private static Log _log = LogFactoryUtil.getLog(PortletPreferencesImpl.class);
    private long _companyId;
    private long _ownerId;
    private int _ownerType;
    private long _plid;
    private String _portletId;
    private Map<String, Preference> _preferences;
    private PortletPreferences _defaultPreferences;

    public PortletPreferencesImpl() {
        this(0L, 0L, 0, 0L, null, new ConcurrentHashMap<String, Preference>());
    }

    public PortletPreferencesImpl(long companyId, long ownerId, int ownerType, long plid, String portletId, Map<String, Preference> preferences) {
        this._companyId = companyId;
        this._ownerId = ownerId;
        this._ownerType = ownerType;
        this._plid = plid;
        this._portletId = portletId;
        this._preferences = preferences;
    }

    public Map<String, String[]> getMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (Map.Entry<String, Preference> entry : this._preferences.entrySet()) {
            String key = entry.getKey();
            Preference preference = entry.getValue();
            map.put(key, this._getActualValues(preference.getValues()));
        }
        return Collections.unmodifiableMap(map);
    }

    public Enumeration<String> getNames() {
        return Collections.enumeration(this._preferences.keySet());
    }

    public String getValue(String key, String def) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Preference preference = this._preferences.get(key);
        String[] values = null;
        if (preference != null) {
            values = preference.getValues();
        }
        if (values != null && values.length > 0) {
            return this._getActualValue(values[0]);
        }
        return this._getActualValue(def);
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        value = this._getXmlSafeValue(value);
        Preference preference = this._preferences.get(key);
        if (preference == null) {
            preference = new Preference(key, value);
            this._preferences.put(key, preference);
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException(key);
        }
        preference.setValues(new String[]{value});
    }

    public String[] getValues(String key, String[] def) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Preference preference = this._preferences.get(key);
        String[] values = null;
        if (preference != null) {
            values = preference.getValues();
        }
        if (values != null && values.length > 0) {
            return this._getActualValues(values);
        }
        return this._getActualValues(def);
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        values = this._getXmlSafeValues(values);
        Preference preference = this._preferences.get(key);
        if (preference == null) {
            preference = new Preference(key, values);
            this._preferences.put(key, preference);
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException(key);
        }
        preference.setValues(values);
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Preference preference = this._preferences.get(key);
        return preference != null && preference.isReadOnly();
    }

    public void reset() {
        this._preferences.clear();
    }

    public void reset(String key) throws ReadOnlyException {
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException(key);
        }
        if (this._defaultPreferences == null) {
            try {
                if (this._portletId != null && !this._portletId.equals("LIFERAY_PORTAL")) {
                    this._defaultPreferences = PortletPreferencesLocalServiceUtil.getDefaultPreferences((long)this._companyId, (String)this._portletId);
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        String[] defaultValues = null;
        if (this._defaultPreferences != null) {
            defaultValues = this._defaultPreferences.getValues(key, defaultValues);
        }
        if (defaultValues != null) {
            this.setValues(key, defaultValues);
        } else {
            this._preferences.remove(key);
        }
    }

    public void store() throws IOException, ValidatorException {
        if (this._portletId == null) {
            throw new UnsupportedOperationException();
        }
        try {
            PreferencesValidator preferencesValidator;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this._companyId, (String)this._portletId);
            if (!this._portletId.equals("LIFERAY_PORTAL") && (preferencesValidator = PortalUtil.getPreferencesValidator((Portlet)portlet)) != null) {
                preferencesValidator.validate((PortletPreferences)this);
            }
            PortletPreferencesLocalServiceUtil.updatePreferences((long)this._ownerId, (int)this._ownerType, (long)this._plid, (String)this._portletId, (PortletPreferences)this);
        }
        catch (SystemException se) {
            throw new IOException(se.getMessage());
        }
    }

    public Object clone() {
        ConcurrentHashMap<String, Preference> preferencesClone = new ConcurrentHashMap<String, Preference>();
        for (Map.Entry<String, Preference> entry : this._preferences.entrySet()) {
            String key = entry.getKey();
            Preference preference = entry.getValue();
            preferencesClone.put(key, (Preference)preference.clone());
        }
        return new PortletPreferencesImpl(this._companyId, this._ownerId, this._ownerType, this._plid, this._portletId, preferencesClone);
    }

    public boolean equals(Object obj) {
        PortletPreferencesImpl portletPreferences = (PortletPreferencesImpl)obj;
        if (this == portletPreferences) {
            return true;
        }
        return this.getCompanyId() == portletPreferences.getCompanyId() && this.getOwnerId() == portletPreferences.getOwnerId() && this.getOwnerType() == portletPreferences.getOwnerType() && this.getPlid() == portletPreferences.getPlid() && this.getPortletId().equals(portletPreferences.getPortletId()) && ((Object)this.getMap()).equals(portletPreferences.getMap());
    }

    protected long getCompanyId() {
        return this._companyId;
    }

    protected long getOwnerId() {
        return this._ownerId;
    }

    protected int getOwnerType() {
        return this._ownerType;
    }

    protected long getPlid() {
        return this._plid;
    }

    protected String getPortletId() {
        return this._portletId;
    }

    protected Map<String, Preference> getPreferences() {
        return this._preferences;
    }

    private String _getActualValue(String value) {
        if (value == null || value.equals(_NULL_VALUE)) {
            return null;
        }
        return XMLFormatter.fromCompactSafe((String)value);
    }

    private String[] _getActualValues(String[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 1 && this._getActualValue(values[0]) == null) {
            return null;
        }
        String[] actualValues = new String[values.length];
        System.arraycopy(values, 0, actualValues, 0, values.length);
        for (int i = 0; i < actualValues.length; ++i) {
            actualValues[i] = this._getActualValue(actualValues[i]);
        }
        return actualValues;
    }

    private String _getXmlSafeValue(String value) {
        if (value == null) {
            return _NULL_VALUE;
        }
        return XMLFormatter.toCompactSafe((String)value);
    }

    private String[] _getXmlSafeValues(String[] values) {
        if (values == null) {
            return new String[]{this._getXmlSafeValue(null)};
        }
        String[] xmlSafeValues = new String[values.length];
        System.arraycopy(values, 0, xmlSafeValues, 0, values.length);
        for (int i = 0; i < xmlSafeValues.length; ++i) {
            if (xmlSafeValues[i] != null) continue;
            xmlSafeValues[i] = this._getXmlSafeValue(xmlSafeValues[i]);
        }
        return xmlSafeValues;
    }
}

