/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.Preference;
import java.util.ArrayList;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class PortletPreferencesSerializer {
    public static PortletPreferences fromDefaultXML(String xml) throws SystemException {
        PortletPreferencesImpl preferences = new PortletPreferencesImpl();
        if (Validator.isNull((String)xml)) {
            return preferences;
        }
        Map<String, Preference> preferencesMap = preferences.getPreferences();
        try {
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            for (Element prefEl : root.elements("preference")) {
                String name = prefEl.elementTextTrim("name");
                ArrayList<String> values = new ArrayList<String>();
                for (Element valueEl : prefEl.elements("value")) {
                    values.add(valueEl.getTextTrim());
                }
                boolean readOnly = GetterUtil.getBoolean((String)prefEl.elementText("read-only"));
                Preference preference = new Preference(name, values.toArray(new String[values.size()]), readOnly);
                preferencesMap.put(name, preference);
            }
            return preferences;
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
    }

    public static PortletPreferencesImpl fromXML(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws SystemException {
        PortletPreferencesImpl preferences = (PortletPreferencesImpl)PortletPreferencesSerializer.fromDefaultXML(xml);
        preferences = new PortletPreferencesImpl(companyId, ownerId, ownerType, plid, portletId, preferences.getPreferences());
        return preferences;
    }

    public static String toXML(PortletPreferencesImpl preferences) {
        Map<String, Preference> preferencesMap = preferences.getPreferences();
        Element portletPreferences = SAXReaderUtil.createElement((String)"portlet-preferences");
        for (Map.Entry<String, Preference> entry : preferencesMap.entrySet()) {
            Preference preference = entry.getValue();
            Element prefEl = SAXReaderUtil.createElement((String)"preference");
            Element nameEl = SAXReaderUtil.createElement((String)"name");
            nameEl.addText(preference.getName());
            prefEl.add(nameEl);
            String[] values = preference.getValues();
            for (int i = 0; i < values.length; ++i) {
                Element valueEl = SAXReaderUtil.createElement((String)"value");
                valueEl.addText(values[i]);
                prefEl.add(valueEl);
            }
            if (preference.isReadOnly()) {
                Element valueEl = SAXReaderUtil.createElement((String)"read-only");
                valueEl.addText("true");
                prefEl.add(valueEl);
            }
            portletPreferences.add(prefEl);
        }
        return portletPreferences.asXML();
    }
}

