/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.servlet.NamespaceServletRequest;
import com.liferay.portal.struts.StrutsURLEncoder;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.MimeResponseImpl;
import com.liferay.portlet.PortletContextImpl;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletResponseImpl;
import com.liferay.portlet.PortletServletRequest;
import com.liferay.portlet.PortletServletResponse;
import com.liferay.util.servlet.DynamicServletRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletRequestDispatcherImpl
implements PortletRequestDispatcher {
    private static Log _log = LogFactoryUtil.getLog(PortletRequestDispatcherImpl.class);
    private RequestDispatcher _requestDispatcher;
    private boolean _named;
    private Portlet _portlet;
    private PortletContextImpl _portletContextImpl;
    private String _path;

    public PortletRequestDispatcherImpl(RequestDispatcher requestDispatcher, boolean named, PortletContextImpl portletContextImpl) {
        this(requestDispatcher, named, portletContextImpl, null);
    }

    public PortletRequestDispatcherImpl(RequestDispatcher requestDispatcher, boolean named, PortletContextImpl portletContextImpl, String path) {
        this._requestDispatcher = requestDispatcher;
        this._named = named;
        this._portlet = portletContextImpl.getPortlet();
        this._portletContextImpl = portletContextImpl;
        this._path = path;
    }

    public void forward(PortletRequest portletRequest, PortletResponse portletResponse) throws IllegalStateException, IOException, PortletException {
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)portletResponse);
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed");
        }
        try {
            this.dispatch(portletRequest, portletResponse, false, false);
        }
        catch (ServletException se) {
            _log.error((Object)se, (Throwable)se);
            throw new PortletException((Throwable)se);
        }
    }

    public void include(PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, PortletException {
        try {
            this.dispatch(portletRequest, portletResponse, false, true);
        }
        catch (ServletException se) {
            _log.error((Object)se, (Throwable)se);
            throw new PortletException((Throwable)se);
        }
    }

    public void include(PortletRequest portletRequest, PortletResponse portletResponse, boolean strutsURLEncoder) throws IOException, PortletException {
        try {
            this.dispatch(portletRequest, portletResponse, strutsURLEncoder, true);
        }
        catch (ServletException se) {
            _log.error((Object)se, (Throwable)se);
            throw new PortletException((Throwable)se);
        }
    }

    public void include(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            this.dispatch((PortletRequest)renderRequest, (PortletResponse)renderResponse, false, true);
        }
        catch (ServletException se) {
            _log.error((Object)se, (Throwable)se);
            throw new PortletException((Throwable)se);
        }
    }

    protected void dispatch(PortletRequest portletRequest, PortletResponse portletResponse, boolean strutsURLEncoder, boolean include) throws IOException, ServletException {
        MimeResponseImpl mimeResponseImpl;
        if (!include && portletResponse instanceof MimeResponseImpl && (mimeResponseImpl = (MimeResponseImpl)portletResponse).isCalledFlushBuffer()) {
            throw new IllegalStateException();
        }
        PortletRequestImpl portletRequestImpl = (PortletRequestImpl)portletRequest;
        PortletResponseImpl portletResponseImpl = PortletResponseImpl.getPortletResponseImpl(portletResponse);
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)portletResponse);
        String pathInfo = null;
        String queryString = null;
        String requestURI = null;
        String servletPath = null;
        if (this._path != null) {
            String pathNoQueryString = this._path;
            int pos = this._path.indexOf("?");
            if (pos != -1) {
                String[] values;
                pathNoQueryString = this._path.substring(0, pos);
                queryString = this._path.substring(pos + 1, this._path.length());
                HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
                String[] queryParamsArray = StringUtil.split((String)queryString, (String)"&");
                for (int i = 0; i < queryParamsArray.length; ++i) {
                    String[] nameValuePair = StringUtil.split((String)queryParamsArray[i], (String)"=");
                    String string = nameValuePair[0];
                    String value = "";
                    if (nameValuePair.length == 2) {
                        value = nameValuePair[1];
                    }
                    if ((values = (String[])queryParams.get(string)) == null) {
                        queryParams.put(string, new String[]{value});
                        continue;
                    }
                    String[] newValues = new String[values.length + 1];
                    System.arraycopy(values, 0, newValues, 0, values.length);
                    newValues[newValues.length - 1] = value;
                    queryParams.put(string, newValues);
                }
                DynamicServletRequest dynamicRequest = null;
                if (portletRequestImpl.isPrivateRequestAttributes()) {
                    String portletNamespace = PortalUtil.getPortletNamespace((String)portletRequestImpl.getPortletName());
                    dynamicRequest = new NamespaceServletRequest(request, portletNamespace, portletNamespace);
                } else {
                    dynamicRequest = new DynamicServletRequest(request);
                }
                for (Map.Entry entry : queryParams.entrySet()) {
                    String name = (String)entry.getKey();
                    values = (String[])entry.getValue();
                    String[] oldValues = dynamicRequest.getParameterValues(name);
                    if (oldValues == null) {
                        dynamicRequest.setParameterValues(name, values);
                        continue;
                    }
                    String[] newValues = ArrayUtil.append((String[])values, (String[])oldValues);
                    dynamicRequest.setParameterValues(name, newValues);
                }
                request = dynamicRequest;
            }
            Portlet portlet = portletRequestImpl.getPortlet();
            PortletApp portletApp = portlet.getPortletApp();
            Set servletURLPatterns = portletApp.getServletURLPatterns();
            for (String string : servletURLPatterns) {
                String string2;
                if (!string.endsWith("/*") || !pathNoQueryString.startsWith(string2 = string.substring(0, pos = string.indexOf("/*")))) continue;
                pathInfo = pathNoQueryString.substring(string2.length());
                servletPath = string2;
                break;
            }
            if (pathInfo == null && servletPath == null) {
                pathInfo = pathNoQueryString;
                servletPath = pathNoQueryString;
            }
            requestURI = portletRequest.getContextPath() + pathNoQueryString;
        }
        PortletServletRequest portletServletRequest = new PortletServletRequest(request, portletRequestImpl, pathInfo, queryString, requestURI, servletPath, this._named, include);
        PortletServletResponse portletServletResponse = new PortletServletResponse(response, portletResponseImpl, include);
        URLEncoder urlEncoder = this._portlet.getURLEncoderInstance();
        if (urlEncoder != null) {
            portletResponseImpl.setURLEncoder(urlEncoder);
        } else if (strutsURLEncoder) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
            StrutsURLEncoder strutsURLEncoderObj = new StrutsURLEncoder(portletServletRequest.getContextPath(), themeDisplay.getPathMain(), (String)this._portletContextImpl.getAttribute("org.apache.struts.action.SERVLET_MAPPING"), (LiferayPortletURL)portletResponseImpl.createRenderURL());
            portletResponseImpl.setURLEncoder(strutsURLEncoderObj);
        }
        if (include) {
            this._requestDispatcher.include((ServletRequest)portletServletRequest, (ServletResponse)portletServletResponse);
        } else {
            this._requestDispatcher.forward((ServletRequest)portletServletRequest, (ServletResponse)portletServletResponse);
        }
    }
}

