/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.ccpp.PortalProfileFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.ProtectedPrincipal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.User;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.servlet.NamespaceServletRequest;
import com.liferay.portal.servlet.SharedSessionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.PortalContextImpl;
import com.liferay.portlet.PortletConfigImpl;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.portlet.PortletSessionImpl;
import com.liferay.portlet.PublicRenderParametersPool;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.UserInfoFactory;
import com.liferay.util.servlet.DynamicServletRequest;
import com.liferay.util.servlet.SharedSessionServletRequest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ccpp.Profile;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletRequestImpl
implements LiferayPortletRequest {
    private static Log _log = LogFactoryUtil.getLog(PortletRequestImpl.class);
    private HttpServletRequest _request;
    private HttpServletRequest _originalRequest;
    private boolean _wapTheme;
    private Portlet _portlet;
    private String _portletName;
    private PortalContext _portalContext;
    private PortletContext _portletContext;
    private WindowState _windowState;
    private PortletMode _portletMode;
    private PortletPreferences _preferences;
    private PortletSessionImpl _session;
    private String _portalSessionId;
    private boolean _invalidSession;
    private String _remoteUser;
    private long _remoteUserId;
    private Principal _userPrincipal;
    private Profile _profile;
    private Locale _locale;
    private long _plid;
    private Map<String, String[]> _publicRenderParameters;

    public void cleanUp() {
        this._request.removeAttribute("javax.portlet.config");
        this._request.removeAttribute("javax.portlet.request");
        this._request.removeAttribute("javax.portlet.response");
        this._request.removeAttribute("javax.portlet.lifecycle_phase");
    }

    public void defineObjects(PortletConfig portletConfig, PortletResponse portletResponse) {
        PortletConfigImpl portletConfigImpl = (PortletConfigImpl)portletConfig;
        this.setAttribute("PORTLET_ID", portletConfigImpl.getPortletId());
        this.setAttribute("javax.portlet.config", portletConfig);
        this.setAttribute("javax.portlet.request", this);
        this.setAttribute("javax.portlet.response", portletResponse);
        this.setAttribute("javax.portlet.lifecycle_phase", this.getLifecycle());
    }

    public Object getAttribute(String name) {
        LinkedHashMap<String, String> value;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (name.equals("javax.portlet.ccpp")) {
            return this.getCCPPProfile();
        }
        if (name.equals("javax.portlet.userinfo") && (value = this.getUserInfo()) != null) {
            return value;
        }
        return this._request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enu = this._request.getAttributeNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (name.equals("javax.servlet.include.path_info")) continue;
            names.add(name);
        }
        return Collections.enumeration(names);
    }

    public String getAuthType() {
        return this._request.getAuthType();
    }

    public Profile getCCPPProfile() {
        if (this._profile == null) {
            this._profile = PortalProfileFactory.getCCPPProfile(this._request);
        }
        return this._profile;
    }

    public String getContextPath() {
        return "/" + this._portletContext.getPortletContextName();
    }

    public Cookie[] getCookies() {
        return this._request.getCookies();
    }

    public String getETag() {
        return null;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._request;
    }

    public abstract String getLifecycle();

    public Locale getLocale() {
        Locale locale = this._locale;
        if (locale == null) {
            locale = this._request.getLocale();
        }
        if (locale == null) {
            locale = LocaleUtil.getDefault();
        }
        return locale;
    }

    public Enumeration<Locale> getLocales() {
        return this._request.getLocales();
    }

    public String getMethod() {
        return this._request.getMethod();
    }

    public HttpServletRequest getOriginalHttpServletRequest() {
        return this._originalRequest;
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this._request.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this._request.getParameterMap());
    }

    public Enumeration<String> getParameterNames() {
        return this._request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this._request.getParameterValues(name);
    }

    public PortalContext getPortalContext() {
        return this._portalContext;
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public PortletMode getPortletMode() {
        return this._portletMode;
    }

    public String getPortletName() {
        return this._portletName;
    }

    public PortletSession getPortletSession() {
        return this._session;
    }

    public PortletSession getPortletSession(boolean create) {
        if (!create && this._invalidSession) {
            return null;
        }
        return this._session;
    }

    public PortletPreferences getPreferences() {
        return new PortletPreferencesWrapper(this.getPreferencesImpl(), this.getLifecycle());
    }

    public PortletPreferencesImpl getPreferencesImpl() {
        return (PortletPreferencesImpl)this._preferences;
    }

    public Map<String, String[]> getPrivateParameterMap() {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        Enumeration<String> enu = this.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = enu.nextElement();
            if (this._portlet.getPublicRenderParameter(name) != null) continue;
            parameterMap.put(name, this.getParameterValues(name));
        }
        return parameterMap;
    }

    public Enumeration<String> getProperties(String name) {
        ArrayList<String> values = new ArrayList<String>();
        String value = this._portalContext.getProperty(name);
        if (value != null) {
            values.add(value);
        }
        return Collections.enumeration(values);
    }

    public String getProperty(String name) {
        return this._portalContext.getProperty(name);
    }

    public Enumeration<String> getPropertyNames() {
        return this._portalContext.getPropertyNames();
    }

    public Map<String, String[]> getPublicParameterMap() {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        Enumeration<String> enu = this.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = enu.nextElement();
            if (this._portlet.getPublicRenderParameter(name) == null) continue;
            parameterMap.put(name, this.getParameterValues(name));
        }
        return parameterMap;
    }

    public String getRemoteUser() {
        return this._remoteUser;
    }

    public Map<String, String[]> getRenderParameters() {
        return RenderParametersPool.get(this._request, this._plid, this._portletName);
    }

    public String getRequestedSessionId() {
        return this._request.getSession().getId();
    }

    public String getResponseContentType() {
        if (this._wapTheme) {
            return "application/vnd.wap.xhtml+xml";
        }
        return "text/html";
    }

    public Enumeration<String> getResponseContentTypes() {
        ArrayList<String> responseContentTypes = new ArrayList<String>();
        responseContentTypes.add(this.getResponseContentType());
        return Collections.enumeration(responseContentTypes);
    }

    public String getScheme() {
        return this._request.getScheme();
    }

    public String getServerName() {
        return this._request.getServerName();
    }

    public int getServerPort() {
        return this._request.getServerPort();
    }

    public LinkedHashMap<String, String> getUserInfo() {
        return UserInfoFactory.getUserInfo(this._remoteUserId, this._portlet);
    }

    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }

    public String getWindowID() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._portletName);
        sb.append("_LAYOUT_");
        sb.append(this._plid);
        return sb.toString();
    }

    public WindowState getWindowState() {
        return this._windowState;
    }

    public void invalidateSession() {
        this._invalidSession = true;
    }

    public boolean isInvalidParameter(String name) {
        return Validator.isNull((String)name) || name.startsWith("p_r_p_") || name.startsWith("r_p_r_p") || PortalUtil.isReservedParameter((String)name);
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        if (portletMode == null || Validator.isNull((String)portletMode.toString())) {
            return true;
        }
        return this._portlet.hasPortletMode(this.getResponseContentType(), portletMode);
    }

    public boolean isPrivateRequestAttributes() {
        return this._portlet.isPrivateRequestAttributes();
    }

    public boolean isRequestedSessionIdValid() {
        if (this._session != null) {
            return this._session.isValid();
        }
        return this._request.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this._request.isSecure();
    }

    public boolean isUserInRole(String role) {
        if (this._remoteUserId <= 0L) {
            return false;
        }
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)this._request);
            String roleLink = (String)this._portlet.getRoleMappers().get(role);
            if (Validator.isNotNull((String)roleLink)) {
                return RoleLocalServiceUtil.hasUserRole((long)this._remoteUserId, (long)companyId, (String)roleLink, (boolean)true);
            }
            return RoleLocalServiceUtil.hasUserRole((long)this._remoteUserId, (long)companyId, (String)role, (boolean)true);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return this._request.isUserInRole(role);
        }
    }

    public boolean isWindowStateAllowed(WindowState windowState) {
        return PortalContextImpl.isSupportedWindowState(windowState);
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._request.removeAttribute(name);
    }

    public void setAttribute(String name, Object obj) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (obj == null) {
            this.removeAttribute(name);
        } else {
            this._request.setAttribute(name, obj);
        }
    }

    public void setPortletMode(PortletMode portletMode) {
        this._portletMode = portletMode;
    }

    public void setWindowState(WindowState windowState) {
        this._windowState = windowState;
    }

    protected void init(HttpServletRequest request, Portlet portlet, InvokerPortlet invokerPortlet, PortletContext portletContext, WindowState windowState, PortletMode portletMode, PortletPreferences preferences, long plid) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        this._portlet = portlet;
        this._portletName = portlet.getPortletId();
        this._publicRenderParameters = PublicRenderParametersPool.get(request, plid);
        String portletNamespace = PortalUtil.getPortletNamespace((String)this._portletName);
        Map<String, Object> sharedSessionAttributes = SharedSessionUtil.getSharedSessionAttributes(request);
        boolean portalSessionShared = false;
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp.isWARFile() && !portlet.isPrivateSessionAttributes()) {
            portalSessionShared = true;
        }
        request = new SharedSessionServletRequest(request, sharedSessionAttributes, portalSessionShared);
        DynamicServletRequest dynamicRequest = null;
        dynamicRequest = portlet.isPrivateRequestAttributes() ? new NamespaceServletRequest(request, portletNamespace, portletNamespace, false) : new DynamicServletRequest(request, false);
        boolean portletFocus = false;
        String ppid = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        if (this._portletName.equals(ppid)) {
            if (themeDisplay.isLifecycleRender() || themeDisplay.isLifecycleResource()) {
                portletFocus = true;
            } else if (themeDisplay.isLifecycleAction() && this.getLifecycle().equals("ACTION_PHASE")) {
                portletFocus = true;
            }
        }
        Map<String, String[]> renderParameters = RenderParametersPool.get(request, plid, this._portletName);
        if (portletFocus) {
            renderParameters = new HashMap<String, String[]>();
            if (this.getLifecycle().equals("RENDER_PHASE") && !LiferayWindowState.isExclusive((HttpServletRequest)request) && !LiferayWindowState.isPopUp((HttpServletRequest)request)) {
                RenderParametersPool.put(request, plid, this._portletName, renderParameters);
            }
            Enumeration enu = request.getParameterNames();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                if (this.isInvalidParameter(name)) continue;
                String[] values = request.getParameterValues(name);
                if (themeDisplay.isLifecycleRender()) {
                    renderParameters.put(name, values);
                }
                if (values == null) continue;
                if (name.startsWith(portletNamespace) && !invokerPortlet.isFacesPortlet()) {
                    name = name.substring(portletNamespace.length());
                }
                dynamicRequest.setParameterValues(name, values);
            }
        } else {
            Set<String> names = renderParameters.keySet();
            for (String name : names) {
                String[] values = renderParameters.get(name);
                dynamicRequest.setParameterValues(name, values);
            }
        }
        this.mergePublicRenderParameters(dynamicRequest, preferences, plid, renderParameters);
        this._request = dynamicRequest;
        this._originalRequest = request;
        this._wapTheme = BrowserSnifferUtil.isWap((HttpServletRequest)this._request);
        this._portlet = portlet;
        this._portalContext = new PortalContextImpl();
        this._portletContext = portletContext;
        this._windowState = windowState;
        this._portletMode = portletMode;
        this._preferences = preferences;
        this._portalSessionId = this._request.getRequestedSessionId();
        this._session = new PortletSessionImpl(this._request, this._portletName, this._portletContext, this._portalSessionId, plid);
        long userId = PortalUtil.getUserId((HttpServletRequest)request);
        String remoteUser = request.getRemoteUser();
        String userPrincipalStrategy = portlet.getUserPrincipalStrategy();
        if (userPrincipalStrategy.equals("screenName")) {
            try {
                User user = PortalUtil.getUser((HttpServletRequest)request);
                this._remoteUser = user.getScreenName();
                this._remoteUserId = user.getUserId();
                this._userPrincipal = new ProtectedPrincipal(this._remoteUser);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        } else if (userId > 0L && remoteUser == null) {
            this._remoteUser = String.valueOf(userId);
            this._remoteUserId = userId;
            this._userPrincipal = new ProtectedPrincipal(this._remoteUser);
        } else {
            this._remoteUser = remoteUser;
            this._remoteUserId = GetterUtil.getLong((String)remoteUser);
            this._userPrincipal = request.getUserPrincipal();
        }
        this._locale = themeDisplay.getLocale();
        this._plid = plid;
    }

    protected void mergePublicRenderParameters(DynamicServletRequest dynamicRequest, PortletPreferences preferences, long plid, Map<String, String[]> renderParameters) {
        Enumeration publicRenderParameters = Collections.enumeration(this._portlet.getPublicRenderParameters());
        while (publicRenderParameters.hasMoreElements()) {
            PublicRenderParameter publicRenderParameter = (PublicRenderParameter)publicRenderParameters.nextElement();
            String name = publicRenderParameter.getIdentifier();
            QName qName = publicRenderParameter.getQName();
            String[] values = this._publicRenderParameters.get(PortletQNameUtil.getKey((QName)qName));
            if (values == null || values.length == 0) continue;
            String[] newValues = dynamicRequest.getParameterValues(name);
            if (newValues != null) {
                values = ArrayUtil.append((String[])newValues, (String[])values);
            }
            dynamicRequest.setParameterValues(name, values);
        }
    }
}

