/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.struts.util.RequestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletResourceBundles {
    private static Log _log = LogFactoryUtil.getLog(PortletResourceBundles.class);
    private static PortletResourceBundles _instance = new PortletResourceBundles();
    private Map<String, Map<String, ResourceBundle>> _contexts = new ConcurrentHashMap<String, Map<String, ResourceBundle>>(new LinkedHashMap());

    public static String getString(PageContext pageContext, String key) {
        return _instance._getString(pageContext, key);
    }

    public static String getString(Locale locale, String key) {
        return _instance._getString(locale, key);
    }

    public static String getString(String languageId, String key) {
        return _instance._getString(languageId, key);
    }

    public static String getString(String servletContextName, String languageId, String key) {
        return _instance._getString(servletContextName, languageId, key);
    }

    public static void put(String servletContextName, String languageId, ResourceBundle bundle) {
        _instance._put(servletContextName, languageId, bundle);
    }

    public static void remove(String servletContextName) {
        _instance._remove(servletContextName);
    }

    private PortletResourceBundles() {
    }

    private ResourceBundle _getBundle(String servletContextName, String languageId) {
        Map<String, ResourceBundle> bundles = this._getBundles(servletContextName);
        return this._getBundle(bundles, languageId);
    }

    private ResourceBundle _getBundle(Map<String, ResourceBundle> bundles, String languageId) {
        ResourceBundle bundle = bundles.get(languageId);
        if (bundle == null) {
            try {
                bundle = new PropertyResourceBundle((InputStream)new UnsyncByteArrayInputStream(new byte[0]));
                bundles.put(languageId, bundle);
            }
            catch (IOException ioe) {
                _log.error((Throwable)ioe);
            }
        }
        return bundle;
    }

    private Map<String, ResourceBundle> _getBundles(String servletContextName) {
        Map<String, ResourceBundle> bundles = this._contexts.get(servletContextName);
        if (bundles == null) {
            bundles = new HashMap<String, ResourceBundle>();
            this._contexts.put(servletContextName, bundles);
        }
        return bundles;
    }

    private String _getString(PageContext pageContext, String key) {
        Locale locale = RequestUtils.getUserLocale((HttpServletRequest)((HttpServletRequest)pageContext.getRequest()), null);
        return this._getString(locale, key);
    }

    private String _getString(Locale locale, String key) {
        return this._getString(LocaleUtil.toLanguageId((Locale)locale), key);
    }

    private String _getString(String languageId, String key) {
        return this._getString(null, languageId, key);
    }

    private String _getString(String servletContextName, String languageId, String key) {
        if (servletContextName != null) {
            ResourceBundle bundle = this._getBundle(servletContextName, languageId);
            return bundle.getString(key);
        }
        for (Map.Entry<String, Map<String, ResourceBundle>> entry : this._contexts.entrySet()) {
            Map<String, ResourceBundle> bundles = entry.getValue();
            ResourceBundle bundle = this._getBundle(bundles, languageId);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException mre) {
            }
        }
        return null;
    }

    private void _put(String servletContextName, String languageId, ResourceBundle bundle) {
        Map<String, ResourceBundle> bundles = this._getBundles(servletContextName);
        bundles.put(languageId, bundle);
    }

    private void _remove(String servletContextName) {
        this._contexts.remove(servletContextName);
    }
}

