/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletURLListener;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.PortletURLListenerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletException;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.ResourceURL;
import javax.portlet.WindowStateException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletResponseImpl
implements LiferayPortletResponse {
    private static Log _log = LogFactoryUtil.getLog(PortletResponseImpl.class);
    private PortletRequestImpl _portletRequestImpl;
    private HttpServletResponse _response;
    private String _portletName;
    private Portlet _portlet;
    private String _namespace;
    private long _companyId;
    private long _plid;
    private URLEncoder _urlEncoder;
    private Map<String, Object> _headers = new LinkedHashMap<String, Object>();
    private boolean _wsrp;

    public static PortletResponseImpl getPortletResponseImpl(PortletResponse portletResponse) {
        PortletResponseImpl portletResponseImpl = null;
        if (portletResponse instanceof PortletResponseImpl) {
            portletResponseImpl = (PortletResponseImpl)portletResponse;
        } else {
            try {
                Method method = portletResponse.getClass().getMethod("getResponse", new Class[0]);
                Object obj = method.invoke((Object)portletResponse, (Object[])null);
                portletResponseImpl = PortletResponseImpl.getPortletResponseImpl((PortletResponse)obj);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get the HTTP servlet resuest from " + portletResponse.getClass().getName());
            }
        }
        return portletResponseImpl;
    }

    public void addDateHeader(String name, long date) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        if (this._headers.containsKey(name)) {
            Long[] values = (Long[])this._headers.get(name);
            ArrayUtil.append((Long[])values, (Long)new Long(date));
            this._headers.put(name, values);
        } else {
            this.setDateHeader(name, date);
        }
    }

    public void addHeader(String name, String value) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        if (this._headers.containsKey(name)) {
            String[] values = (String[])this._headers.get(name);
            ArrayUtil.append((String[])values, (String)value);
            this._headers.put(name, values);
        } else {
            this.setHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        if (this._headers.containsKey(name)) {
            Integer[] values = (Integer[])this._headers.get(name);
            ArrayUtil.append((Integer[])values, (Integer)new Integer(value));
            this._headers.put(name, values);
        } else {
            this.setIntHeader(name, value);
        }
    }

    public void addProperty(Cookie cookie) {
        if (Validator.isNull((Object)cookie)) {
            throw new IllegalArgumentException();
        }
        if (this._headers.containsKey("cookies")) {
            Object[] cookies = (Cookie[])this._headers.get("cookies");
            ArrayUtil.append((Object[])cookies, (Object)cookie);
            this._headers.put("cookies", cookies);
        } else {
            Cookie[] cookies = new Cookie[]{cookie};
            this._headers.put("cookies", cookies);
        }
    }

    public void addProperty(String key, Element element) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
    }

    public void addProperty(String key, String value) {
        if (Validator.isNull((String)key)) {
            throw new IllegalArgumentException();
        }
        this.addHeader(key, value);
    }

    public PortletURL createActionURL() {
        return this.createActionURL(this._portletName);
    }

    public LiferayPortletURL createActionURL(String portletName) {
        return this.createPortletURLImpl(portletName, "ACTION_PHASE");
    }

    public Element createElement(String tagName) throws DOMException {
        return null;
    }

    public PortletURLImpl createPortletURLImpl(String lifecycle) {
        return this.createPortletURLImpl(this._portletName, lifecycle);
    }

    public PortletURLImpl createPortletURLImpl(String portletName, String lifecycle) {
        return this.createPortletURLImpl(this._plid, portletName, lifecycle);
    }

    public PortletURLImpl createPortletURLImpl(long plid, String portletName, String lifecycle) {
        block22: {
            try {
                Layout layout = (Layout)this._portletRequestImpl.getAttribute("LAYOUT");
                PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)this._portletName);
                long layoutId = GetterUtil.getLong((String)portletSetup.getValue("portlet-setup-link-to-layout-id", null));
                if (layoutId > 0L) {
                    try {
                        Layout linkedLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layoutId);
                        plid = linkedLayout.getPlid();
                    }
                    catch (PortalException pe) {}
                } else {
                    plid = GetterUtil.getLong((String)portletSetup.getValue("portlet-setup-link-to-plid", String.valueOf(plid)));
                }
            }
            catch (SystemException e) {
                if (!_log.isWarnEnabled()) break block22;
                _log.warn((Throwable)e);
            }
        }
        if (plid == 0L) {
            plid = this._plid;
        }
        PortletURLImpl portletURLImpl = null;
        Portlet portlet = this.getPortlet();
        String portletURLClass = portlet.getPortletURLClass();
        if (portlet.getPortletId().equals(portletName) && Validator.isNotNull((String)portletURLClass)) {
            try {
                Class<?> portletURLClassObj = Class.forName(portletURLClass);
                Constructor<?> constructor = portletURLClassObj.getConstructor(PortletResponseImpl.class, Long.TYPE, String.class);
                portletURLImpl = (PortletURLImpl)constructor.newInstance(this, plid, lifecycle);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        if (portletURLImpl == null) {
            portletURLImpl = new PortletURLImpl(this._portletRequestImpl, portletName, plid, lifecycle);
        }
        PortletApp portletApp = portlet.getPortletApp();
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            try {
                PortletURLGenerationListener portletURLGenerationListener = PortletURLListenerFactory.create(portletURLListener);
                if (lifecycle.equals("ACTION_PHASE")) {
                    portletURLGenerationListener.filterActionURL((PortletURL)portletURLImpl);
                    continue;
                }
                if (lifecycle.equals("RENDER_PHASE")) {
                    portletURLGenerationListener.filterRenderURL((PortletURL)portletURLImpl);
                    continue;
                }
                if (!lifecycle.equals("RESOURCE_PHASE")) continue;
                portletURLGenerationListener.filterResourceURL((ResourceURL)portletURLImpl);
            }
            catch (PortletException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        try {
            portletURLImpl.setWindowState(this._portletRequestImpl.getWindowState());
        }
        catch (WindowStateException wse) {
            _log.error((Object)wse.getMessage());
        }
        try {
            portletURLImpl.setPortletMode(this._portletRequestImpl.getPortletMode());
        }
        catch (PortletModeException pme) {
            _log.error((Object)pme.getMessage());
        }
        if (lifecycle.equals("ACTION_PHASE")) {
            portletURLImpl.setCopyCurrentPublicRenderParameters(true);
        }
        if (lifecycle.equals("RESOURCE_PHASE")) {
            portletURLImpl.setCopyCurrentPublicRenderParameters(true);
            portletURLImpl.setCopyCurrentRenderParameters(true);
        }
        return portletURLImpl;
    }

    public PortletURL createRenderURL() {
        return this.createRenderURL(this._portletName);
    }

    public LiferayPortletURL createRenderURL(String portletName) {
        return this.createPortletURLImpl(portletName, "RENDER_PHASE");
    }

    public ResourceURL createResourceURL() {
        return this.createResourceURL(this._portletName);
    }

    public LiferayPortletURL createResourceURL(String portletName) {
        return this.createPortletURLImpl(portletName, "RESOURCE_PHASE");
    }

    public String encodeURL(String path) {
        if (path == null || !path.startsWith("#") && !path.startsWith("/") && path.indexOf("://") == -1) {
            throw new IllegalArgumentException("URL path must start with a '/' or include '://'");
        }
        if (this._urlEncoder != null) {
            return this._urlEncoder.encodeURL(this._response, path);
        }
        return path;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._portletRequestImpl.getHttpServletRequest();
    }

    public HttpServletResponse getHttpServletResponse() {
        return this._response;
    }

    public abstract String getLifecycle();

    public String getNamespace() {
        if (this._wsrp) {
            return "wsrp_rewrite_";
        }
        if (this._namespace == null) {
            this._namespace = PortalUtil.getPortletNamespace((String)this._portletName);
        }
        return this._namespace;
    }

    public long getPlid() {
        return this._plid;
    }

    public Portlet getPortlet() {
        if (this._portlet == null) {
            try {
                this._portlet = PortletLocalServiceUtil.getPortletById((long)this._companyId, (String)this._portletName);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        return this._portlet;
    }

    public String getPortletName() {
        return this._portletName;
    }

    public PortletRequestImpl getPortletRequest() {
        return this._portletRequestImpl;
    }

    public Map<String, String[]> getProperties() {
        LinkedHashMap<String, String[]> properties = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, Object> entry : this._headers.entrySet()) {
            String name = entry.getKey();
            Object[] values = (Object[])entry.getValue();
            String[] valuesString = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                valuesString[i] = values[i].toString();
            }
            properties.put(name, valuesString);
        }
        return properties;
    }

    public URLEncoder getUrlEncoder() {
        return this._urlEncoder;
    }

    public void setDateHeader(String name, long date) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        if (date <= 0L) {
            this._headers.remove(name);
        } else {
            this._headers.put(name, new Long[]{new Long(date)});
        }
    }

    public void setHeader(String name, String value) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        if (Validator.isNull((String)value)) {
            this._headers.remove(name);
        } else {
            this._headers.put(name, new String[]{value});
        }
    }

    public void setIntHeader(String name, int value) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException();
        }
        if (value <= 0) {
            this._headers.remove(name);
        } else {
            this._headers.put(name, new Integer[]{new Integer(value)});
        }
    }

    public void setPlid(long plid) {
        Layout layout;
        this._plid = plid;
        if (this._plid <= 0L && (layout = (Layout)this._portletRequestImpl.getAttribute("LAYOUT")) != null) {
            this._plid = layout.getPlid();
        }
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.setHeader(key, value);
    }

    public void setURLEncoder(URLEncoder urlEncoder) {
        this._urlEncoder = urlEncoder;
    }

    public void transferHeaders(HttpServletResponse response) {
        for (Map.Entry<String, Object> entry : this._headers.entrySet()) {
            int i$;
            int len$;
            Object[] arr$;
            String name = entry.getKey();
            Object values = entry.getValue();
            if (values instanceof Integer[]) {
                Integer[] intValues = (Integer[])values;
                arr$ = intValues;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    int value = (Integer)arr$[i$];
                    if (response.containsHeader(name)) {
                        response.addIntHeader(name, value);
                        continue;
                    }
                    response.setIntHeader(name, value);
                }
                continue;
            }
            if (values instanceof Long[]) {
                Long[] dateValues = (Long[])values;
                arr$ = dateValues;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    long value = (Long)arr$[i$];
                    if (response.containsHeader(name)) {
                        response.addDateHeader(name, value);
                        continue;
                    }
                    response.setDateHeader(name, value);
                }
                continue;
            }
            if (values instanceof String[]) {
                String[] stringValues = (String[])values;
                for (String value : stringValues) {
                    if (response.containsHeader(name)) {
                        response.addHeader(name, value);
                        continue;
                    }
                    response.setHeader(name, value);
                }
                continue;
            }
            if (!(values instanceof Cookie[])) continue;
            Cookie[] cookies = (Cookie[])values;
            for (Cookie cookie : cookies) {
                response.addCookie(cookie);
            }
        }
    }

    protected void init(PortletRequestImpl portletRequestImpl, HttpServletResponse response, String portletName, long companyId, long plid) {
        this._portletRequestImpl = portletRequestImpl;
        this._response = response;
        this._portletName = portletName;
        this._companyId = companyId;
        this._wsrp = ParamUtil.getBoolean((HttpServletRequest)this.getHttpServletRequest(), (String)"wsrp");
        this.setPlid(plid);
    }
}

