/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ProtectedPrincipal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletServletSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletServletRequest
extends HttpServletRequestWrapper {
    private static Log _log = LogFactoryUtil.getLog(PortletServletRequest.class);
    private HttpServletRequest _request;
    private PortletRequestImpl _portletRequestImpl;
    private String _lifecycle;
    private String _pathInfo;
    private String _queryString;
    private String _remoteUser;
    private String _requestURI;
    private String _servletPath;
    private Principal _userPrincipal;
    private boolean _named;
    private boolean _include;

    public PortletServletRequest(HttpServletRequest request, PortletRequestImpl portletRequestImpl, String pathInfo, String queryString, String requestURI, String servletPath, boolean named, boolean include) {
        super(request);
        this._request = request;
        this._portletRequestImpl = portletRequestImpl;
        this._lifecycle = this._portletRequestImpl.getLifecycle();
        this._pathInfo = pathInfo;
        this._queryString = queryString;
        this._requestURI = GetterUtil.getString((String)requestURI);
        this._servletPath = GetterUtil.getString((String)servletPath);
        this._named = named;
        this._include = include;
        long userId = PortalUtil.getUserId((HttpServletRequest)request);
        String remoteUser = request.getRemoteUser();
        Portlet portlet = portletRequestImpl.getPortlet();
        String userPrincipalStrategy = portlet.getUserPrincipalStrategy();
        if (userPrincipalStrategy.equals("screenName")) {
            try {
                User user = PortalUtil.getUser((HttpServletRequest)request);
                this._remoteUser = user.getScreenName();
                this._userPrincipal = new ProtectedPrincipal(this._remoteUser);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        } else if (userId > 0L && remoteUser == null) {
            this._remoteUser = String.valueOf(userId);
            this._userPrincipal = new ProtectedPrincipal(this._remoteUser);
        } else {
            this._remoteUser = remoteUser;
            this._userPrincipal = request.getUserPrincipal();
        }
    }

    public Object getAttribute(String name) {
        if (this._include || name == null) {
            return this._request.getAttribute(name);
        }
        if (name.equals("javax.servlet.forward.context_path")) {
            if (this._named) {
                return null;
            }
            return this._portletRequestImpl.getContextPath();
        }
        if (name.equals("javax.servlet.forward.path_info")) {
            if (this._named) {
                return null;
            }
            return this._pathInfo;
        }
        if (name.equals("javax.servlet.forward.query_string")) {
            if (this._named) {
                return null;
            }
            return this._queryString;
        }
        if (name.equals("javax.servlet.forward.request_uri")) {
            if (this._named) {
                return null;
            }
            return this._requestURI;
        }
        if (name.equals("javax.servlet.forward.servlet_path")) {
            if (this._named) {
                return null;
            }
            return this._servletPath;
        }
        return this._request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this._request.getAttributeNames();
    }

    public String getAuthType() {
        return this._request.getAuthType();
    }

    public String getCharacterEncoding() {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            return this._request.getCharacterEncoding();
        }
        return null;
    }

    public int getContentLength() {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            return this._request.getContentLength();
        }
        return 0;
    }

    public String getContentType() {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            return this._request.getContentType();
        }
        return null;
    }

    public String getContextPath() {
        return this._portletRequestImpl.getContextPath();
    }

    public Cookie[] getCookies() {
        return this._request.getCookies();
    }

    public long getDateHeader(String name) {
        return GetterUtil.getLong((String)this.getHeader(name), (long)-1L);
    }

    public String getHeader(String name) {
        HttpServletRequest request = this._portletRequestImpl.getHttpServletRequest();
        return request.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        HttpServletRequest request = this._portletRequestImpl.getHttpServletRequest();
        return request.getHeaderNames();
    }

    public Enumeration<String> getHeaders(String name) {
        HttpServletRequest request = this._portletRequestImpl.getHttpServletRequest();
        return request.getHeaders(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            return this._request.getInputStream();
        }
        return null;
    }

    public int getIntHeader(String name) {
        return GetterUtil.getInteger((String)this.getHeader(name));
    }

    public String getLocalAddr() {
        return null;
    }

    public Locale getLocale() {
        return this._portletRequestImpl.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this._request.getLocales();
    }

    public String getLocalName() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getMethod() {
        if (this._lifecycle.equals("RENDER_PHASE")) {
            return "GET";
        }
        return this._request.getMethod();
    }

    public String getParameter(String name) {
        return this._request.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this._request.getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return this._request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this._request.getParameterValues(name);
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getPathTranslated() {
        return this._request.getPathTranslated();
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getQueryString() {
        return this._queryString;
    }

    public BufferedReader getReader() throws IOException {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            return this._request.getReader();
        }
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this._request.getRequestDispatcher(path);
    }

    public String getRequestedSessionId() {
        return this._request.getRequestedSessionId();
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getRequestURI() {
        return this._requestURI;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getRemoteUser() {
        return this._remoteUser;
    }

    public String getScheme() {
        return this._request.getScheme();
    }

    public String getServerName() {
        return this._request.getServerName();
    }

    public int getServerPort() {
        return this._request.getServerPort();
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public HttpSession getSession() {
        return new PortletServletSession(this._request.getSession(), this._portletRequestImpl);
    }

    public HttpSession getSession(boolean create) {
        return new PortletServletSession(this._request.getSession(create), this._portletRequestImpl);
    }

    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this._request.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdValid() {
        return this._request.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this._request.isSecure();
    }

    public boolean isUserInRole(String role) {
        return this._portletRequestImpl.isUserInRole(role);
    }

    public void removeAttribute(String name) {
        this._request.removeAttribute(name);
    }

    public void setAttribute(String name, Object obj) {
        this._request.setAttribute(name, obj);
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            this._request.setCharacterEncoding(encoding);
        }
    }
}

