/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.LiferayPortletSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletSessionImpl
implements LiferayPortletSession {
    private HttpServletRequest _request;
    private HttpSession _session;
    private String _portletName;
    private PortletContext _portletContext;
    private long _creationTime;
    private long _lastAccessedTime;
    private int _interval;
    private boolean _new;
    private boolean _invalid;
    private String _portalSessionId;
    private long _plid;

    public static final String getPortletScope(String portletName, long plid) {
        StringBuilder sb = new StringBuilder();
        sb.append("javax.portlet.p.");
        sb.append(portletName);
        sb.append("_LAYOUT_");
        sb.append(plid);
        return sb.toString();
    }

    public static final String getPortletScopeName(String portletName, long plid, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(PortletSessionImpl.getPortletScope(portletName, plid));
        sb.append("?");
        sb.append(name);
        return sb.toString();
    }

    public PortletSessionImpl(HttpServletRequest request, String portletName, PortletContext portletContext, String portalSessionId, long plid) {
        this._request = request;
        this._portletName = portletName;
        this._portletContext = portletContext;
        this._lastAccessedTime = this._creationTime = System.currentTimeMillis();
        this._interval = this.getHttpSession().getMaxInactiveInterval();
        this._new = true;
        this._invalid = false;
        this._portalSessionId = portalSessionId;
        this._plid = plid;
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._invalid) {
            throw new IllegalStateException();
        }
        return this.getAttribute(name, 2);
    }

    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._invalid) {
            throw new IllegalStateException();
        }
        if (scope == 2) {
            return this.getHttpSession().getAttribute(this._getPortletScopeName(name));
        }
        return this.getHttpSession().getAttribute(name);
    }

    public Map<String, Object> getAttributeMap() {
        return this.getAttributeMap(2);
    }

    public Map<String, Object> getAttributeMap(int scope) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<String> enu = this.getAttributeNames(scope);
        while (enu.hasMoreElements()) {
            String name = enu.nextElement();
            Object value = this.getAttribute(name);
            map.put(name, value);
        }
        return map;
    }

    public Enumeration<String> getAttributeNames() {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        return this.getAttributeNames(2);
    }

    public Enumeration<String> getAttributeNames(int scope) {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        if (scope == 2) {
            ArrayList<String> attributeNames = new ArrayList<String>();
            String portletScope = PortletSessionImpl.getPortletScope(this._portletName, this._plid);
            Enumeration enu = this.getHttpSession().getAttributeNames();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                StringTokenizer st = new StringTokenizer(name, "?");
                if (st.countTokens() != 2 || !st.nextToken().equals(portletScope)) continue;
                attributeNames.add(st.nextToken());
            }
            return Collections.enumeration(attributeNames);
        }
        return this.getHttpSession().getAttributeNames();
    }

    public long getCreationTime() {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        return this._creationTime;
    }

    public HttpSession getHttpSession() {
        if (this._session == null) {
            return this._request.getSession();
        }
        return this._session;
    }

    public String getId() {
        return this.getHttpSession().getId();
    }

    public long getLastAccessedTime() {
        return this._lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this._interval;
    }

    public String getPortalSessionId() {
        return this._portalSessionId;
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public void invalidate() {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        this.getHttpSession().invalidate();
        this._invalid = true;
    }

    public boolean isNew() {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        return this._new;
    }

    public boolean isValid() {
        return !this._invalid;
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._invalid) {
            throw new IllegalStateException();
        }
        this.removeAttribute(name, 2);
    }

    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._invalid) {
            throw new IllegalStateException();
        }
        if (scope == 2) {
            this.getHttpSession().removeAttribute(this._getPortletScopeName(name));
        } else {
            this.getHttpSession().removeAttribute(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._invalid) {
            throw new IllegalStateException();
        }
        this.setAttribute(name, value, 2);
    }

    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._invalid) {
            throw new IllegalStateException();
        }
        if (scope == 2) {
            this.getHttpSession().setAttribute(this._getPortletScopeName(name), value);
        } else {
            this.getHttpSession().setAttribute(name, value);
        }
    }

    public void setHttpSession(HttpSession session) {
        this._session = session;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this._lastAccessedTime = lastAccessedTime;
        this._new = false;
    }

    public void setMaxInactiveInterval(int interval) {
        this._interval = interval;
    }

    private String _getPortletScopeName(String name) {
        return PortletSessionImpl.getPortletScopeName(this._portletName, this._plid, name);
    }
}

