/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.portlet.PortletPreferences;

public class PortletSetupUtil {
    private static Log _log = LogFactoryUtil.getLog(PortletSetupUtil.class);

    public static final JSONObject cssToJSON(PortletPreferences portletSetup, String css) throws Exception {
        return PortletSetupUtil._toJSONObject(portletSetup, css);
    }

    public static final String cssToString(PortletPreferences portletSetup) {
        String css;
        block3: {
            css = portletSetup.getValue("portlet-setup-css", "");
            try {
                if (Validator.isNotNull((String)css)) {
                    return PortletSetupUtil._toJSONObject(portletSetup, css).toString();
                }
            }
            catch (Exception e) {
                css = null;
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)e);
            }
        }
        return css;
    }

    private static final JSONObject _toJSONObject(PortletPreferences portletSetup, String css) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Transform CSS to JSON " + css));
        }
        JSONObject jsonObj = JSONFactoryUtil.createJSONObject((String)css);
        JSONObject portletData = JSONFactoryUtil.createJSONObject();
        jsonObj.put("portletData", portletData);
        JSONObject titles = JSONFactoryUtil.createJSONObject();
        portletData.put("titles", titles);
        Locale[] locales = LanguageUtil.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            String languageId = LocaleUtil.toLanguageId((Locale)locales[i]);
            String title = portletSetup.getValue("portlet-setup-title-" + languageId, null);
            if (!Validator.isNotNull((String)languageId)) continue;
            titles.put(languageId, title);
        }
        boolean useCustomTitle = GetterUtil.getBoolean((String)portletSetup.getValue("portlet-setup-use-custom-title", null));
        boolean showBorders = GetterUtil.getBoolean((String)portletSetup.getValue("portlet-setup-show-borders", null), (boolean)true);
        long linkToLayoutId = GetterUtil.getLong((String)portletSetup.getValue("portlet-setup-link-to-layout-id", null));
        portletData.put("useCustomTitle", useCustomTitle);
        portletData.put("showBorders", showBorders);
        portletData.put("portletLinksTarget", linkToLayoutId);
        return jsonObj;
    }
}

