/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.action;

import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.search.lucene.LuceneIndexer;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.ShutdownUtil;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.util.log4j.Log4JUtil;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class EditServerAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(EditServerAction.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.admin.error");
            return;
        }
        PortletPreferences preferences = PrefsPropsUtil.getPreferences();
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String redirect = null;
        if (cmd.equals("addLogLevel")) {
            this.addLogLevel(actionRequest);
        } else if (cmd.equals("cacheDb")) {
            this.cacheDb();
        } else if (cmd.equals("cacheMulti")) {
            this.cacheMulti();
        } else if (cmd.equals("cacheSingle")) {
            this.cacheSingle();
        } else if (cmd.startsWith("convertProcess.")) {
            redirect = this.convertProcess(actionRequest, actionResponse, cmd);
        } else if (cmd.equals("gc")) {
            this.gc();
        } else if (cmd.equals("reIndex")) {
            this.reIndex(actionRequest);
        } else if (cmd.equals("shutdown")) {
            this.shutdown(actionRequest);
        } else if (cmd.equals("threadDump")) {
            this.threadDump();
        } else if (cmd.equals("updateFileUploads")) {
            this.updateFileUploads(actionRequest, preferences);
        } else if (cmd.equals("updateLogLevels")) {
            this.updateLogLevels(actionRequest);
        } else if (cmd.equals("updateMail")) {
            this.updateMail(actionRequest, preferences);
        } else if (cmd.equals("updateOpenOffice")) {
            this.updateOpenOffice(actionRequest, preferences);
        }
        this.sendRedirect(actionRequest, actionResponse, redirect);
    }

    protected void addLogLevel(ActionRequest actionRequest) throws Exception {
        String loggerName = ParamUtil.getString((PortletRequest)actionRequest, (String)"loggerName");
        String priority = ParamUtil.getString((PortletRequest)actionRequest, (String)"priority");
        Logger logger = Logger.getLogger((String)loggerName);
        logger.setLevel(Level.toLevel((String)priority));
    }

    protected void cacheDb() throws Exception {
        CacheRegistry.clear();
    }

    protected void cacheMulti() throws Exception {
        MultiVMPoolUtil.clear();
    }

    protected void cacheSingle() throws Exception {
        WebCachePoolUtil.clear();
    }

    protected String convertProcess(ActionRequest actionRequest, ActionResponse actionResponse, String cmd) throws Exception {
        String path;
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        PortletSession portletSession = actionRequest.getPortletSession();
        String className = StringUtil.replaceFirst((String)cmd, (String)"convertProcess.", (String)"");
        ConvertProcess convertProcess = (ConvertProcess)InstancePool.get((String)className);
        String[] parameters = convertProcess.getParameterNames();
        if (parameters != null) {
            String[] values = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                String parameter = className + "." + parameters[i];
                if (parameters[i].contains("=") && parameters[i].contains(";")) {
                    String[] parameterPair = StringUtil.split((String)parameters[i], (String)"=");
                    parameter = className + "." + parameterPair[0];
                }
                values[i] = ParamUtil.getString((PortletRequest)actionRequest, (String)parameter);
            }
            convertProcess.setParameterValues(values);
        }
        if ((path = convertProcess.getPath()) != null) {
            PortletURL portletURL = actionResponseImpl.createRenderURL();
            portletURL.setWindowState(WindowState.MAXIMIZED);
            portletURL.setParameter("struts_action", path);
            return portletURL.toString();
        }
        MaintenanceUtil.maintain(portletSession.getId(), className);
        MessageBusUtil.sendMessage((String)"liferay/convert_process", (Object)className);
        return null;
    }

    protected void gc() throws Exception {
        Runtime.getRuntime().gc();
    }

    protected String getFileExtensions(ActionRequest actionRequest, String name) {
        String value = ParamUtil.getString((PortletRequest)actionRequest, (String)name);
        return value.replace(", .", ",.");
    }

    protected void reIndex(ActionRequest actionRequest) throws Exception {
        String portletId = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletId");
        long[] companyIds = PortalInstances.getCompanyIds();
        if (Validator.isNull((String)portletId)) {
            for (long companyId : companyIds) {
                try {
                    LuceneIndexer indexer = new LuceneIndexer(companyId);
                    indexer.reIndex();
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
        } else {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyIds[0], (String)portletId);
            if (portlet == null) {
                return;
            }
            Indexer indexer = portlet.getIndexerInstance();
            if (indexer == null) {
                return;
            }
            for (long companyId : companyIds) {
                try {
                    SearchEngineUtil.deletePortletDocuments((long)companyId, (String)portletId);
                    indexer.reIndex(new String[]{String.valueOf(companyId)});
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected void shutdown(ActionRequest actionRequest) throws Exception {
        long minutes = (long)ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minutes") * 60000L;
        String message = ParamUtil.getString((PortletRequest)actionRequest, (String)"message");
        if (minutes <= 0L) {
            ShutdownUtil.cancel();
        } else {
            ShutdownUtil.shutdown(minutes, message);
        }
    }

    protected void threadDump() throws Exception {
        String jvm = System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
        StringBuilder sb = new StringBuilder("Full thread dump " + jvm + "\n\n");
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Thread thread : stackTraces.keySet()) {
            StackTraceElement[] elements = stackTraces.get(thread);
            sb.append("\"");
            sb.append(thread.getName());
            sb.append("\"");
            if (thread.getThreadGroup() != null) {
                sb.append(" ");
                sb.append("(");
                sb.append(thread.getThreadGroup().getName());
                sb.append(")");
            }
            sb.append(", priority=" + thread.getPriority());
            sb.append(", id=" + thread.getId());
            sb.append(", state=" + (Object)((Object)thread.getState()));
            sb.append("\n");
            for (int i = 0; i < elements.length; ++i) {
                sb.append("\t" + elements[i] + "\n");
            }
            sb.append("\n");
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)sb.toString());
        } else {
            _log.error((Object)("Thread dumps require the log level to be at least INFO for " + ((Object)((Object)this)).getClass().getName()));
        }
    }

    protected void updateFileUploads(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String dlFileExtensions = this.getFileExtensions(actionRequest, "dlFileExtensions");
        long dlFileMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dlFileMaxSize");
        String igImageExtensions = this.getFileExtensions(actionRequest, "igImageExtensions");
        long igImageMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"igImageMaxSize");
        long igThumbnailMaxDimension = ParamUtil.getLong((PortletRequest)actionRequest, (String)"igImageThumbnailMaxDimensions");
        String journalImageExtensions = this.getFileExtensions(actionRequest, "journalImageExtensions");
        long journalImageSmallMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"journalImageSmallMaxSize");
        String shoppingImageExtensions = this.getFileExtensions(actionRequest, "shoppingImageExtensions");
        long scImageMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"scImageMaxSize");
        long scImageThumbnailMaxHeight = ParamUtil.getLong((PortletRequest)actionRequest, (String)"scImageThumbnailMaxHeight");
        long scImageThumbnailMaxWidth = ParamUtil.getLong((PortletRequest)actionRequest, (String)"scImageThumbnailMaxWidth");
        long shoppingImageLargeMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageLargeMaxSize");
        long shoppingImageMediumMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageMediumMaxSize");
        long shoppingImageSmallMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageSmallMaxSize");
        long uploadServletRequestImplMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"uploadServletRequestImplMaxSize");
        String uploadServletRequestImplTempDir = ParamUtil.getString((PortletRequest)actionRequest, (String)"uploadServletRequestImplTempDir");
        long usersImageMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"usersImageMaxSize");
        preferences.setValue("dl.file.extensions", dlFileExtensions);
        preferences.setValue("dl.file.max.size", String.valueOf(dlFileMaxSize));
        preferences.setValue("ig.image.extensions", igImageExtensions);
        preferences.setValue("ig.image.max.size", String.valueOf(igImageMaxSize));
        preferences.setValue("ig.image.thumbnail.max.dimension", String.valueOf(igThumbnailMaxDimension));
        preferences.setValue("journal.image.extensions", journalImageExtensions);
        preferences.setValue("journal.image.small.max.size", String.valueOf(journalImageSmallMaxSize));
        preferences.setValue("shopping.image.extensions", shoppingImageExtensions);
        preferences.setValue("shopping.image.large.max.size", String.valueOf(shoppingImageLargeMaxSize));
        preferences.setValue("shopping.image.medium.max.size", String.valueOf(shoppingImageMediumMaxSize));
        preferences.setValue("shopping.image.small.max.size", String.valueOf(shoppingImageSmallMaxSize));
        preferences.setValue("sc.image.max.size", String.valueOf(scImageMaxSize));
        preferences.setValue("sc.image.thumbnail.max.height", String.valueOf(scImageThumbnailMaxHeight));
        preferences.setValue("sc.image.thumbnail.max.width", String.valueOf(scImageThumbnailMaxWidth));
        preferences.setValue("com.liferay.portal.upload.UploadServletRequestImpl.max.size", String.valueOf(uploadServletRequestImplMaxSize));
        if (Validator.isNotNull((String)uploadServletRequestImplTempDir)) {
            preferences.setValue("com.liferay.portal.upload.UploadServletRequestImpl.temp.dir", uploadServletRequestImplTempDir);
        }
        preferences.setValue("users.image.max.size", String.valueOf(usersImageMaxSize));
        preferences.store();
    }

    protected void updateLogLevels(ActionRequest actionRequest) throws Exception {
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith("logLevel")) continue;
            String loggerName = name.substring(8, name.length());
            String priority = ParamUtil.getString((PortletRequest)actionRequest, (String)name, (String)Level.INFO.toString());
            Log4JUtil.setLevel((String)loggerName, (String)priority);
        }
    }

    protected void updateMail(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String advancedProperties = ParamUtil.getString((PortletRequest)actionRequest, (String)"advancedProperties");
        String pop3Host = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3Host");
        String pop3Password = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3Password");
        int pop3Port = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"pop3Port");
        boolean pop3Secure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"pop3Secure");
        String pop3User = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3User");
        String smtpHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpHost");
        String smtpPassword = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpPassword");
        int smtpPort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"smtpPort");
        boolean smtpSecure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"smtpSecure");
        String smtpUser = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpUser");
        String storeProtocol = "pop3";
        if (pop3Secure) {
            storeProtocol = "pop3s";
        }
        String transportProtocol = "smtp";
        if (smtpSecure) {
            transportProtocol = "smtps";
        }
        preferences.setValue("mail.session.mail", "true");
        preferences.setValue("mail.session.mail.advanced.properties", advancedProperties);
        preferences.setValue("mail.session.mail.pop3.host", pop3Host);
        preferences.setValue("mail.session.mail.pop3.password", pop3Password);
        preferences.setValue("mail.session.mail.pop3.port", String.valueOf(pop3Port));
        preferences.setValue("mail.session.mail.pop3.user", pop3User);
        preferences.setValue("mail.session.mail.smtp.host", smtpHost);
        preferences.setValue("mail.session.mail.smtp.password", smtpPassword);
        preferences.setValue("mail.session.mail.smtp.port", String.valueOf(smtpPort));
        preferences.setValue("mail.session.mail.smtp.user", smtpUser);
        preferences.setValue("mail.session.mail.store.protocol", storeProtocol);
        preferences.setValue("mail.session.mail.transport.protocol", transportProtocol);
        preferences.store();
        MailServiceUtil.clearSession();
    }

    protected void updateOpenOffice(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean enabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enabled");
        int port = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"port");
        preferences.setValue("openoffice.server.enabled", String.valueOf(enabled));
        preferences.setValue("openoffice.server.port", String.valueOf(port));
        preferences.store();
    }
}

