/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.job;

import com.liferay.portal.kernel.job.IntervalJob;
import com.liferay.portal.kernel.job.JobExecutionContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;

public class LDAPImportJob
implements IntervalJob {
    private static Log _log = LogFactoryUtil.getLog(LDAPImportJob.class);
    private long _interval;

    public LDAPImportJob() {
        try {
            long rawInterval = PrefsPropsUtil.getLong("ldap.import.interval", PropsValues.LDAP_IMPORT_INTERVAL);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Interval " + rawInterval + " minutes"));
            }
            this._interval = rawInterval * 60000L;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void execute(JobExecutionContext context) {
        try {
            PortalLDAPUtil.importFromLDAP();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public long getInterval() {
        return this._interval;
    }
}

