/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.amazonrankings.util;

import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.amazonrankings.model.AmazonRankings;
import com.liferay.portlet.amazonrankings.util.AmazonRankingsUtil;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class AmazonRankingsWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 1200000L;
    private String _isbn;

    public AmazonRankingsWebCacheItem(String isbn) {
        this._isbn = isbn;
    }

    public Object convert(String key) {
        String isbn = this._isbn;
        AmazonRankings amazonRankings = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("http://ecs.amazonaws.com/onca/xml?Service=");
            sb.append("AWSECommerceService&AWSAccessKeyId=");
            sb.append(AmazonRankingsUtil.getAmazonAccessKeyId());
            sb.append("&Operation=ItemLookup&IdType=ASIN&ItemId=");
            sb.append(isbn);
            sb.append("&ResponseGroup=Images,ItemAttributes,Offers,SalesRank&");
            sb.append("Version=2009-02-01");
            String xml = HttpUtil.URLtoString((String)sb.toString());
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            if (root == null) {
                return null;
            }
            Element items = root.element("Items");
            if (items == null) {
                return null;
            }
            Element item = items.element("Item");
            if (item == null) {
                return null;
            }
            Element itemAttributes = item.element("ItemAttributes");
            if (itemAttributes == null) {
                return null;
            }
            String productName = itemAttributes.elementText("Title");
            String catalog = "";
            String[] authors = this.getAuthors(itemAttributes);
            String releaseDateAsString = itemAttributes.elementText("PublicationDate");
            Date releaseDate = this.getReleaseDate(releaseDateAsString);
            String manufacturer = itemAttributes.elementText("Manufacturer");
            String smallImageURL = this.getImageURL(item, "SmallImage");
            String mediumImageURL = this.getImageURL(item, "MediumImage");
            String largeImageURL = this.getImageURL(item, "LargeImage");
            double listPrice = this.getPrice(itemAttributes.element("ListPrice"));
            double ourPrice = 0.0;
            Element offerListing = this.getOfferListing(item);
            if (offerListing != null) {
                ourPrice = this.getPrice(offerListing.element("Price"));
            }
            double usedPrice = 0.0;
            double collectiblePrice = 0.0;
            double thirdPartyNewPrice = 0.0;
            Element offerSummary = item.element("OfferSummary");
            if (offerSummary != null) {
                usedPrice = this.getPrice(offerSummary.element("LowestUsedPrice"));
                collectiblePrice = this.getPrice(offerSummary.element("LowestCollectiblePrice"));
                thirdPartyNewPrice = this.getPrice(offerSummary.element("LowestNewPrice"));
            }
            int salesRank = GetterUtil.getInteger((String)item.elementText("SalesRank"));
            String media = "";
            String availability = this.getAvailability(offerListing);
            amazonRankings = new AmazonRankings(isbn, productName, catalog, authors, releaseDate, releaseDateAsString, manufacturer, smallImageURL, mediumImageURL, largeImageURL, listPrice, ourPrice, usedPrice, collectiblePrice, thirdPartyNewPrice, salesRank, media, availability);
        }
        catch (Exception e) {
            // empty catch block
        }
        return amazonRankings;
    }

    public long getRefreshTime() {
        return 1200000L;
    }

    protected String[] getAuthors(Element itemAttributes) {
        ArrayList<String> authors = new ArrayList<String>();
        for (Element author : itemAttributes.elements("Author")) {
            authors.add(author.getText());
        }
        return authors.toArray(new String[authors.size()]);
    }

    protected String getAvailability(Element offerListing) {
        if (offerListing == null) {
            return null;
        }
        Element availabilityAttributes = offerListing.element("AvailabilityAttributes");
        return availabilityAttributes.elementText("AvailabilityType");
    }

    protected String getImageURL(Element item, String name) {
        String imageURL = null;
        Element image = item.element(name);
        if (image != null) {
            imageURL = image.elementText("URL");
        }
        return imageURL;
    }

    protected Element getOfferListing(Element item) {
        Element offers = item.element("Offers");
        if (offers == null) {
            return null;
        }
        Element offer = offers.element("Offer");
        if (offer == null) {
            return null;
        }
        return offer.element("OfferListing");
    }

    protected double getPrice(Element price) {
        if (price == null) {
            return 0.0;
        }
        return (double)GetterUtil.getInteger((String)price.elementText("Amount")) * 0.01;
    }

    protected Date getReleaseDate(String releaseDateAsString) {
        if (Validator.isNull((String)releaseDateAsString)) {
            return null;
        }
        DateFormat dateFormat = null;
        dateFormat = releaseDateAsString.length() > 7 ? DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd", (Locale)Locale.US) : DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM", (Locale)Locale.US);
        return GetterUtil.getDate((String)releaseDateAsString, (DateFormat)dateFormat);
    }
}

