/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.announcements.EntryContentException;
import com.liferay.portlet.announcements.EntryDisplayDateException;
import com.liferay.portlet.announcements.EntryExpirationDateException;
import com.liferay.portlet.announcements.EntryTitleException;
import com.liferay.portlet.announcements.job.CheckEntryJob;
import com.liferay.portlet.announcements.model.AnnouncementsDelivery;
import com.liferay.portlet.announcements.model.AnnouncementsEntry;
import com.liferay.portlet.announcements.service.base.AnnouncementsEntryLocalServiceBaseImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnouncementsEntryLocalServiceImpl
extends AnnouncementsEntryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(AnnouncementsEntryLocalServiceImpl.class);

    public AnnouncementsEntry addEntry(long userId, long classNameId, long classPK, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority, boolean alert) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new EntryDisplayDateException());
        Date expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new EntryExpirationDateException());
        Date now = new Date();
        this.validate(title, content);
        long entryId = this.counterLocalService.increment();
        AnnouncementsEntry entry = this.announcementsEntryPersistence.create(entryId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setCreateDate(now);
        entry.setModifiedDate(now);
        entry.setClassNameId(classNameId);
        entry.setClassPK(classPK);
        entry.setTitle(title);
        entry.setContent(content);
        entry.setUrl(url);
        entry.setType(type);
        entry.setDisplayDate(displayDate);
        entry.setExpirationDate(expirationDate);
        entry.setPriority(priority);
        entry.setAlert(alert);
        this.announcementsEntryPersistence.update((BaseModel)entry, false);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), AnnouncementsEntry.class.getName(), entry.getEntryId(), false, false, false);
        return entry;
    }

    public void checkEntries() throws PortalException, SystemException {
        Date now = new Date();
        List entries = this.announcementsEntryFinder.findByDisplayDate(now, new Date(now.getTime() - CheckEntryJob.INTERVAL));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + entries.size() + " entries"));
        }
        for (AnnouncementsEntry entry : entries) {
            try {
                this.notifyUsers(entry);
            }
            catch (IOException ioe) {
                throw new SystemException((Throwable)ioe);
            }
        }
    }

    public void deleteEntry(AnnouncementsEntry entry) throws PortalException, SystemException {
        this.announcementsEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource(entry.getCompanyId(), AnnouncementsEntry.class.getName(), 4, entry.getEntryId());
        this.announcementsFlagLocalService.deleteFlags(entry.getEntryId());
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        AnnouncementsEntry entry = this.announcementsEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public List<AnnouncementsEntry> getEntries(long userId, LinkedHashMap<Long, long[]> scopes, boolean alert, int flagValue, int start, int end) throws SystemException {
        return this.getEntries(userId, scopes, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue, start, end);
    }

    public List<AnnouncementsEntry> getEntries(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) throws SystemException {
        return this.announcementsEntryFinder.findByScopes(userId, scopes, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue, start, end);
    }

    public List<AnnouncementsEntry> getEntries(long classNameId, long classPK, boolean alert, int start, int end) throws SystemException {
        return this.announcementsEntryPersistence.findByC_C_A(classNameId, classPK, alert, start, end);
    }

    public List<AnnouncementsEntry> getEntries(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) throws SystemException {
        return this.announcementsEntryFinder.findByScope(userId, classNameId, classPKs, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue, start, end);
    }

    public int getEntriesCount(long userId, LinkedHashMap<Long, long[]> scopes, boolean alert, int flagValue) throws SystemException {
        return this.getEntriesCount(userId, scopes, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue);
    }

    public int getEntriesCount(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) throws SystemException {
        return this.announcementsEntryFinder.countByScopes(userId, scopes, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue);
    }

    public int getEntriesCount(long classNameId, long classPK, boolean alert) throws SystemException {
        return this.announcementsEntryPersistence.countByC_C_A(classNameId, classPK, alert);
    }

    public int getEntriesCount(long userId, long classNameId, long[] classPKs, boolean alert, int flagValue) throws SystemException {
        return this.getEntriesCount(userId, classNameId, classPKs, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue);
    }

    public int getEntriesCount(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) throws SystemException {
        return this.announcementsEntryFinder.countByScope(userId, classNameId, classPKs, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue);
    }

    public AnnouncementsEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.announcementsEntryPersistence.findByPrimaryKey(entryId);
    }

    public List<AnnouncementsEntry> getUserEntries(long userId, int start, int end) throws SystemException {
        return this.announcementsEntryPersistence.findByUserId(userId, start, end);
    }

    public int getUserEntriesCount(long userId) throws SystemException {
        return this.announcementsEntryPersistence.countByUserId(userId);
    }

    public AnnouncementsEntry updateEntry(long userId, long entryId, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new EntryDisplayDateException());
        Date expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new EntryExpirationDateException());
        this.validate(title, content);
        AnnouncementsEntry entry = this.announcementsEntryPersistence.findByPrimaryKey(entryId);
        entry.setModifiedDate(new Date());
        entry.setTitle(title);
        entry.setContent(content);
        entry.setUrl(url);
        entry.setType(type);
        entry.setDisplayDate(displayDate);
        entry.setExpirationDate(expirationDate);
        entry.setPriority(priority);
        this.announcementsEntryPersistence.update((BaseModel)entry, false);
        this.announcementsFlagLocalService.deleteFlags(entry.getEntryId());
        return entry;
    }

    protected void notifyUsers(AnnouncementsEntry entry) throws IOException, PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(entry.getCompanyId());
        String className = entry.getClassName();
        long classPK = entry.getClassPK();
        String fromName = PropsValues.ANNOUNCEMENTS_EMAIL_FROM_NAME;
        String fromAddress = PropsValues.ANNOUNCEMENTS_EMAIL_FROM_ADDRESS;
        String toName = PropsValues.ANNOUNCEMENTS_EMAIL_TO_NAME;
        String toAddress = PropsValues.ANNOUNCEMENTS_EMAIL_TO_ADDRESS;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("announcementsDeliveryEmailOrSms", entry.getType());
        if (classPK > 0L) {
            if (className.equals(Group.class.getName())) {
                Group group = this.groupPersistence.findByPrimaryKey(classPK);
                toName = group.getName();
                params.put("usersGroups", classPK);
            } else if (className.equals(Organization.class.getName())) {
                Organization organization = this.organizationPersistence.findByPrimaryKey(classPK);
                toName = organization.getName();
                params.put("usersOrgs", classPK);
            } else if (className.equals(Role.class.getName())) {
                Role role = this.rolePersistence.findByPrimaryKey(classPK);
                toName = role.getName();
                params.put("usersRoles", classPK);
            } else if (className.equals(UserGroup.class.getName())) {
                UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(classPK);
                toName = userGroup.getName();
                params.put("usersUserGroups", classPK);
            }
        }
        ArrayList<User> users = null;
        if (className.equals(User.class.getName())) {
            User user = this.userLocalService.getUserById(classPK);
            toName = user.getFullName();
            toAddress = user.getEmailAddress();
            users = new ArrayList<User>();
            if (Validator.isNotNull((String)toAddress)) {
                users.add(user);
            }
        } else {
            users = this.userLocalService.search(company.getCompanyId(), null, Boolean.TRUE, params, -1, -1, (OrderByComparator)null);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Notifying " + users.size() + " users"));
        }
        ArrayList<InternetAddress> bulkAddresses = new ArrayList<InternetAddress>();
        for (User user : users) {
            AnnouncementsDelivery announcementsDelivery = this.announcementsDeliveryLocalService.getUserDelivery(user.getUserId(), entry.getType());
            if (announcementsDelivery.isEmail()) {
                InternetAddress address = new InternetAddress(user.getEmailAddress(), user.getFullName());
                bulkAddresses.add(address);
            }
            if (!announcementsDelivery.isSms()) continue;
            String smsSn = user.getContact().getSmsSn();
            InternetAddress address = new InternetAddress(smsSn, user.getFullName());
            bulkAddresses.add(address);
        }
        if (bulkAddresses.size() == 0) {
            return;
        }
        String subject = ContentUtil.get(PropsValues.ANNOUNCEMENTS_EMAIL_SUBJECT);
        String body = ContentUtil.get(PropsValues.ANNOUNCEMENTS_EMAIL_BODY);
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$ENTRY_CONTENT$]", "[$ENTRY_ID$]", "[$ENTRY_TITLE$]", "[$ENTRY_TYPE$]", "[$ENTRY_URL$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{entry.getContent(), String.valueOf(entry.getEntryId()), entry.getTitle(), LanguageUtil.get((Locale)company.getLocale(), (String)entry.getType()), entry.getUrl(), fromAddress, fromName, company.getVirtualHost(), LanguageUtil.get((Locale)company.getLocale(), (String)(entry.isAlert() ? "alert" : "announcement")), toAddress, toName});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$ENTRY_CONTENT$]", "[$ENTRY_ID$]", "[$ENTRY_TITLE$]", "[$ENTRY_TYPE$]", "[$ENTRY_URL$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{entry.getContent(), String.valueOf(entry.getEntryId()), entry.getTitle(), LanguageUtil.get((Locale)company.getLocale(), (String)entry.getType()), entry.getUrl(), fromAddress, fromName, company.getVirtualHost(), LanguageUtil.get((Locale)company.getLocale(), (String)(entry.isAlert() ? "alert" : "announcement")), toAddress, toName});
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        InternetAddress to = new InternetAddress(toAddress, toName);
        InternetAddress[] bulkAddressesArray = bulkAddresses.toArray(new InternetAddress[bulkAddresses.size()]);
        MailMessage message = new MailMessage(from, to, subject, body, true);
        message.setBulkAddresses(bulkAddressesArray);
        this.mailService.sendEmail(message);
    }

    protected void validate(String title, String content) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new EntryTitleException();
        }
        if (Validator.isNull((String)content)) {
            throw new EntryContentException();
        }
    }
}

