/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.util;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnouncementsUtil {
    private static long _GROUP_CLASS_NAME_ID = PortalUtil.getClassNameId((String)Group.class.getName());
    private static long _ORGANIZATION_CLASS_NAME_ID = PortalUtil.getClassNameId((String)Organization.class.getName());
    private static long _ROLE_CLASS_NAME_ID = PortalUtil.getClassNameId((String)Role.class.getName());
    private static long _USER_CLASS_NAME_ID = PortalUtil.getClassNameId((String)User.class.getName());
    private static long _USER_GROUP_CLASS_NAME_ID = PortalUtil.getClassNameId((String)UserGroup.class.getName());

    public static LinkedHashMap<Long, long[]> getAnnouncementScopes(long userId) throws PortalException, SystemException {
        List userGroups;
        List organizations;
        LinkedHashMap<Long, long[]> scopes = new LinkedHashMap<Long, long[]>();
        scopes.put(new Long(0L), new long[]{0L});
        scopes.put(_USER_CLASS_NAME_ID, new long[]{userId});
        ArrayList<Group> groupsList = new ArrayList<Group>();
        List groups = GroupLocalServiceUtil.getUserGroups((long)userId, (boolean)true);
        if (groups.size() > 0) {
            scopes.put(_GROUP_CLASS_NAME_ID, AnnouncementsUtil._getGroupIds(groups));
            groupsList.addAll(groups);
        }
        if ((organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)userId, (boolean)true)).size() > 0) {
            scopes.put(_ORGANIZATION_CLASS_NAME_ID, AnnouncementsUtil._getOrganizationIds(organizations));
            for (Organization organization : organizations) {
                groupsList.add(organization.getGroup());
            }
        }
        if (groupsList.size() > 0) {
            List roles = RoleLocalServiceUtil.getUserRelatedRoles((long)userId, groupsList);
            roles = ListUtil.copy((List)roles);
            for (Group group : groupsList) {
                roles.addAll(RoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)group.getGroupId()));
                roles.addAll(RoleLocalServiceUtil.getUserGroupGroupRoles((long)userId, (long)group.getGroupId()));
            }
            if (roles.size() > 0) {
                scopes.put(_ROLE_CLASS_NAME_ID, AnnouncementsUtil._getRoleIds(roles));
            }
        }
        if ((userGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)userId)).size() > 0) {
            scopes.put(_USER_GROUP_CLASS_NAME_ID, AnnouncementsUtil._getUserGroupIds(userGroups));
        }
        return scopes;
    }

    private static long[] _getGroupIds(List<Group> groups) {
        long[] groupIds = new long[groups.size()];
        int i = 0;
        for (Group group : groups) {
            groupIds[i++] = group.getGroupId();
        }
        return groupIds;
    }

    private static long[] _getOrganizationIds(List<Organization> organizations) {
        long[] organizationIds = new long[organizations.size()];
        int i = 0;
        for (Organization organization : organizations) {
            organizationIds[i++] = organization.getOrganizationId();
        }
        return organizationIds;
    }

    private static long[] _getRoleIds(List<Role> roles) {
        long[] roleIds = new long[roles.size()];
        int i = 0;
        for (Role role : roles) {
            roleIds[i++] = role.getRoleId();
        }
        return roleIds;
    }

    private static long[] _getUserGroupIds(List<UserGroup> userGroups) {
        long[] userGroupIds = new long[userGroups.size()];
        int i = 0;
        for (UserGroup userGroup : userGroups) {
            userGroupIds[i++] = userGroup.getUserGroupId();
        }
        return userGroupIds;
    }
}

