/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher;

import com.liferay.portal.kernel.portlet.BaseFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetPublisherFriendlyURLMapper
extends BaseFriendlyURLMapper {
    private static final String _MAPPING = "asset_publisher";
    private static final String _PORTLET_DEFAULT_INSTANCE = "101_INSTANCE_0000";
    private static final String _PORTLET_ID = "101";

    public String buildPath(LiferayPortletURL portletURL) {
        String friendlyURLPath = null;
        String strutsAction = GetterUtil.getString((String)portletURL.getParameter("struts_action"));
        WindowState windowState = portletURL.getWindowState();
        if (strutsAction.equals("/asset_publisher/view_content") && (windowState == null || !windowState.equals((Object)LiferayWindowState.EXCLUSIVE) && !windowState.equals((Object)LiferayWindowState.POP_UP))) {
            String portletId = portletURL.getPortletId();
            String assetId = portletURL.getParameter("assetId");
            String type = GetterUtil.getString((String)portletURL.getParameter("type"), (String)"content");
            String urlTitle = portletURL.getParameter("urlTitle");
            if (Validator.isNotNull((String)portletId) && Validator.isNotNull((String)assetId)) {
                if (portletId.equals(_PORTLET_DEFAULT_INSTANCE)) {
                    portletId = _PORTLET_ID;
                }
                int pos = portletId.indexOf("_INSTANCE_");
                String instanceId = null;
                instanceId = pos > 0 ? portletId.substring(pos + 10) : portletId;
                friendlyURLPath = "/asset_publisher/" + instanceId + "/" + type + "/";
                if (Validator.isNotNull((String)urlTitle)) {
                    friendlyURLPath = friendlyURLPath + urlTitle;
                    portletURL.addParameterIncludedInPath("urlTitle");
                } else {
                    friendlyURLPath = friendlyURLPath + "id/" + assetId;
                }
                portletURL.addParameterIncludedInPath("type");
                portletURL.addParameterIncludedInPath("assetId");
            }
        }
        if (Validator.isNotNull(friendlyURLPath)) {
            portletURL.addParameterIncludedInPath("p_p_id");
            portletURL.addParameterIncludedInPath("struts_action");
        }
        return friendlyURLPath;
    }

    public String getMapping() {
        return _MAPPING;
    }

    public String getPortletId() {
        return _PORTLET_ID;
    }

    public void populateParams(String friendlyURLPath, Map<String, String[]> params) {
        int x = friendlyURLPath.indexOf("/", 1);
        String[] urlFragments = StringUtil.split((String)friendlyURLPath.substring(x + 1), (String)"/");
        if (urlFragments.length > 2) {
            String instanceId = urlFragments[0];
            String type = urlFragments[1];
            String assetId = null;
            String urlTitle = null;
            if (urlFragments.length > 3) {
                assetId = urlFragments[3];
            } else {
                urlTitle = urlFragments[2];
            }
            String portletId = "101_INSTANCE_" + instanceId;
            if (Validator.equals((Object)portletId, (Object)_PORTLET_ID)) {
                portletId = _PORTLET_DEFAULT_INSTANCE;
                params.put("p_p_id", new String[]{portletId});
                params.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
            } else {
                params.put("p_p_id", new String[]{portletId});
                params.put("p_p_state", new String[]{WindowState.NORMAL.toString()});
            }
            params.put("p_p_lifecycle", new String[]{"0"});
            params.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
            String namespace = "_" + portletId + "_";
            params.put(namespace + "struts_action", new String[]{"/asset_publisher/view_content"});
            if (Validator.isNotNull((String)assetId)) {
                params.put(namespace + "assetId", new String[]{assetId});
            } else {
                params.put(namespace + "type", new String[]{type});
                params.put(namespace + "urlTitle", new String[]{urlTitle});
            }
        }
    }
}

