/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.action;

import com.liferay.portal.kernel.portlet.BaseConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.tags.TagsEntryException;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class ConfigurationActionImpl
extends BaseConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
            PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
            if (cmd.equals("add-selection")) {
                AssetPublisherUtil.addSelection(actionRequest, preferences);
            } else if (cmd.equals("move-selection-down")) {
                this.moveSelectionDown(actionRequest, preferences);
            } else if (cmd.equals("move-selection-up")) {
                this.moveSelectionUp(actionRequest, preferences);
            } else if (cmd.equals("remove-selection")) {
                this.removeSelection(actionRequest, preferences);
            } else if (cmd.equals("selection-style")) {
                this.setSelectionStyle(actionRequest, preferences);
            } else if (cmd.equals("update")) {
                String selectionStyle = preferences.getValue("selection-style", "dynamic");
                if (selectionStyle.equals("dynamic")) {
                    this.updateDynamicSettings(actionRequest, preferences);
                } else if (selectionStyle.equals("manual")) {
                    this.updateManualSettings(actionRequest, preferences);
                }
            }
            if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                preferences.store();
                SessionMessages.add((PortletRequest)actionRequest, (String)(portletConfig.getPortletName() + ".doConfigure"));
            }
        }
        catch (Exception e) {
            if (e instanceof TagsEntryException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    public String render(PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return "/html/portlet/asset_publisher/configuration.jsp";
    }

    protected void moveSelectionDown(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetOrder");
        if (assetOrder >= (manualEntries = preferences.getValues("manual-entries", new String[0])).length - 1 || assetOrder < 0) {
            return;
        }
        String temp = manualEntries[assetOrder + 1];
        manualEntries[assetOrder + 1] = manualEntries[assetOrder];
        manualEntries[assetOrder] = temp;
        preferences.setValues("manual-entries", manualEntries);
    }

    protected void moveSelectionUp(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetOrder");
        if (assetOrder >= (manualEntries = preferences.getValues("manual-entries", new String[0])).length || assetOrder <= 0) {
            return;
        }
        String temp = manualEntries[assetOrder - 1];
        manualEntries[assetOrder - 1] = manualEntries[assetOrder];
        manualEntries[assetOrder] = temp;
        preferences.setValues("manual-entries", manualEntries);
    }

    protected void removeSelection(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetOrder");
        if (assetOrder >= (manualEntries = preferences.getValues("manual-entries", new String[0])).length) {
            return;
        }
        String[] newEntries = new String[manualEntries.length - 1];
        int j = 0;
        for (int i = 0; i < manualEntries.length; ++i) {
            if (i == assetOrder) continue;
            newEntries[j++] = manualEntries[i];
        }
        preferences.setValues("manual-entries", newEntries);
    }

    protected void setSelectionStyle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String selectionStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"selectionStyle");
        String displayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"displayStyle");
        preferences.setValue("selection-style", selectionStyle);
        if (selectionStyle.equals("manual") || selectionStyle.equals("view-count")) {
            preferences.setValue("show-query-logic", String.valueOf(false));
        }
        if (!selectionStyle.equals("view-count") && displayStyle.equals("view-count-details")) {
            preferences.setValue("display-style", "full-content");
        }
    }

    protected void updateDynamicSettings(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long userId = themeDisplay.getUserId();
        long groupId = themeDisplay.getScopeGroupId();
        String[] entries = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"entries"));
        String[] notEntries = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"notEntries"));
        boolean mergeUrlTags = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeUrlTags");
        boolean andOperator = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"andOperator");
        long classNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classNameId");
        String category = ParamUtil.getString((PortletRequest)actionRequest, (String)"category");
        String displayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"displayStyle");
        boolean showAssetTitle = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showAssetTitle");
        boolean showContextLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showContextLink");
        int abstractLength = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"abstractLength");
        String assetLinkBehaviour = ParamUtil.getString((PortletRequest)actionRequest, (String)"assetLinkBehaviour");
        String orderByColumn1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByColumn1");
        String orderByColumn2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByColumn2");
        String orderByType1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByType1");
        String orderByType2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByType2");
        boolean excludeZeroViewCount = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"excludeZeroViewCount");
        boolean showQueryLogic = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showQueryLogic");
        int delta = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"delta");
        String paginationType = ParamUtil.getString((PortletRequest)actionRequest, (String)"paginationType");
        boolean showAvailableLocales = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showAvailableLocales");
        boolean enableComments = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableComments");
        boolean enableCommentRatings = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableCommentRatings");
        boolean enableRatings = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableRatings");
        String medatadaFields = ParamUtil.getString((PortletRequest)actionRequest, (String)"metadataFields");
        preferences.setValue("selection-style", "dynamic");
        preferences.setValues("entries", entries);
        preferences.setValues("not-entries", notEntries);
        preferences.setValue("merge-url-tags", String.valueOf(mergeUrlTags));
        preferences.setValue("and-operator", String.valueOf(andOperator));
        preferences.setValue("class-name-id", String.valueOf(classNameId));
        preferences.setValue("category", category);
        preferences.setValue("display-style", displayStyle);
        preferences.setValue("show-asset-title", String.valueOf(showAssetTitle));
        preferences.setValue("show-context-link", String.valueOf(showContextLink));
        preferences.setValue("abstract-length", String.valueOf(abstractLength));
        preferences.setValue("asset-link-behaviour", assetLinkBehaviour);
        preferences.setValue("order-by-column-1", orderByColumn1);
        preferences.setValue("order-by-column-2", orderByColumn2);
        preferences.setValue("order-by-type-1", orderByType1);
        preferences.setValue("order-by-type-2", orderByType2);
        preferences.setValue("exclude-zero-view-count", String.valueOf(excludeZeroViewCount));
        preferences.setValue("show-query-logic", String.valueOf(showQueryLogic));
        preferences.setValue("delta", String.valueOf(delta));
        preferences.setValue("pagination-type", paginationType);
        preferences.setValue("show-available-locales", String.valueOf(showAvailableLocales));
        preferences.setValue("enable-ratings", String.valueOf(enableRatings));
        preferences.setValue("enable-comments", String.valueOf(enableComments));
        preferences.setValue("enable-comment-ratings", String.valueOf(enableCommentRatings));
        preferences.setValue("metadata-fields", medatadaFields);
        TagsEntryLocalServiceUtil.checkEntries((long)userId, (long)groupId, (String[])entries);
        TagsEntryLocalServiceUtil.checkEntries((long)userId, (long)groupId, (String[])notEntries);
    }

    protected void updateManualSettings(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String displayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"displayStyle");
        boolean showAssetTitle = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showAssetTitle");
        boolean showContextLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showContextLink");
        int abstractLength = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"abstractLength");
        String assetLinkBehaviour = ParamUtil.getString((PortletRequest)actionRequest, (String)"assetLinkBehaviour");
        boolean showAvailableLocales = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showAvailableLocales");
        boolean enableComments = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableComments");
        boolean enableCommentRatings = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableCommentRatings");
        boolean enableRatings = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableRatings");
        boolean enableTagBasedNavigation = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableTagBasedNavigation");
        String medatadaFields = ParamUtil.getString((PortletRequest)actionRequest, (String)"metadataFields");
        preferences.setValue("selection-style", "manual");
        preferences.setValue("display-style", displayStyle);
        preferences.setValue("show-asset-title", String.valueOf(showAssetTitle));
        preferences.setValue("show-context-link", String.valueOf(showContextLink));
        preferences.setValue("abstract-length", String.valueOf(abstractLength));
        preferences.setValue("asset-link-behaviour", assetLinkBehaviour);
        preferences.setValue("show-available-locales", String.valueOf(showAvailableLocales));
        preferences.setValue("enable-comments", String.valueOf(enableComments));
        preferences.setValue("enable-comment-ratings", String.valueOf(enableCommentRatings));
        preferences.setValue("enable-ratings", String.valueOf(enableRatings));
        preferences.setValue("enable-tag-based-navigation", String.valueOf(enableTagBasedNavigation));
        preferences.setValue("metadata-fields", medatadaFields);
    }
}

