/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.tags.model.TagsAsset;
import com.liferay.portlet.tags.service.TagsAssetLocalServiceUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetPublisherUtil {
    public static final String TYPE_BLOG = "blog";
    public static final String TYPE_BOOKMARK = "bookmark";
    public static final String TYPE_CONTENT = "content";
    public static final String TYPE_DOCUMENT = "document";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_THREAD = "thread";
    public static final String TYPE_WIKI = "wiki";
    private static Log _log = LogFactoryUtil.getLog(AssetPublisherUtil.class);

    public static void addAndStoreSelection(ActionRequest actionRequest, String className, long classPK, int assetOrder) throws Exception {
        String referringPortletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"referringPortletResource");
        if (Validator.isNull((String)referringPortletResource)) {
            return;
        }
        TagsAsset asset = TagsAssetLocalServiceUtil.getAsset((String)className, (long)classPK);
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)referringPortletResource);
        AssetPublisherUtil.addSelection(className, asset.getAssetId(), assetOrder, preferences);
        preferences.store();
    }

    public static void addSelection(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String assetType = ParamUtil.getString((PortletRequest)actionRequest, (String)"assetType");
        long assetId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"assetId");
        int assetOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetOrder");
        AssetPublisherUtil.addSelection(assetType, assetId, assetOrder, preferences);
    }

    public static void addSelection(String assetType, long assetId, int assetOrder, PortletPreferences preferences) throws Exception {
        String[] manualEntries = preferences.getValues("manual-entries", new String[0]);
        String assetConfig = AssetPublisherUtil._assetConfiguration(assetType, assetId);
        if (assetOrder > -1) {
            manualEntries[assetOrder] = assetConfig;
        } else {
            manualEntries = ArrayUtil.append((String[])manualEntries, (String)assetConfig);
        }
        preferences.setValues("manual-entries", manualEntries);
    }

    public static void addRecentFolderId(PortletRequest portletRequest, String className, long classPK) {
        AssetPublisherUtil._getRecentFolderIds(portletRequest).put(className, classPK);
    }

    public static long getRecentFolderId(PortletRequest portletRequest, String className) {
        Long classPK = AssetPublisherUtil._getRecentFolderIds(portletRequest).get(className);
        if (classPK == null) {
            return 0L;
        }
        return classPK;
    }

    public static void removeAndStoreSelection(List<Long> assetIds, PortletPreferences preferences) throws Exception {
        if (assetIds.size() == 0) {
            return;
        }
        Object[] manualEntries = preferences.getValues("manual-entries", new String[0]);
        List manualEntriesList = ListUtil.fromArray((Object[])manualEntries);
        Iterator itr = manualEntriesList.iterator();
        while (itr.hasNext()) {
            String assetEntry = (String)itr.next();
            Document doc = SAXReaderUtil.read((String)assetEntry);
            Element root = doc.getRootElement();
            long assetId = GetterUtil.getLong((String)root.element("asset-id").getText());
            if (!assetIds.contains(assetId)) continue;
            itr.remove();
        }
        preferences.setValues("manual-entries", manualEntriesList.toArray(new String[manualEntriesList.size()]));
        preferences.store();
    }

    private static String _assetConfiguration(String assetType, long assetId) {
        String xml;
        block2: {
            xml = null;
            try {
                Document doc = SAXReaderUtil.createDocument((String)"UTF-8");
                Element asset = doc.addElement("asset");
                asset.addElement("asset-type").addText(assetType);
                asset.addElement("asset-id").addText(String.valueOf(assetId));
                xml = doc.formattedString("");
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)ioe);
            }
        }
        return xml;
    }

    private static Map<String, Long> _getRecentFolderIds(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        String key = AssetPublisherUtil.class + "_" + themeDisplay.getScopeGroupId();
        HashMap<String, Long> recentFolderIds = (HashMap<String, Long>)session.getAttribute(key);
        if (recentFolderIds == null) {
            recentFolderIds = new HashMap<String, Long>();
        }
        session.setAttribute(key, recentFolderIds);
        return recentFolderIds;
    }
}

