/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs;

import com.liferay.portal.kernel.portlet.BaseFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsFriendlyURLMapper
extends BaseFriendlyURLMapper {
    private static final String _MAPPING = "blogs";
    private static final String _PORTLET_ID = "33";

    public String buildPath(LiferayPortletURL portletURL) {
        String friendlyURLPath = null;
        String strutsAction = GetterUtil.getString((String)portletURL.getParameter("struts_action"));
        if (strutsAction.equals("/blogs/rss")) {
            friendlyURLPath = "/blogs/rss";
        } else if (strutsAction.equals("/blogs/view_entry")) {
            String entryId = portletURL.getParameter("entryId");
            String urlTitle = portletURL.getParameter("urlTitle");
            if (Validator.isNotNull((String)entryId)) {
                friendlyURLPath = "/blogs/" + entryId;
                portletURL.addParameterIncludedInPath("entryId");
            } else if (Validator.isNotNull((String)urlTitle)) {
                friendlyURLPath = "/blogs/" + HttpUtil.encodeURL((String)urlTitle);
                portletURL.addParameterIncludedInPath("urlTitle");
            }
        }
        if (Validator.isNotNull((String)friendlyURLPath)) {
            portletURL.addParameterIncludedInPath("p_p_id");
            portletURL.addParameterIncludedInPath("struts_action");
            WindowState windowState = portletURL.getWindowState();
            if (windowState.equals((Object)WindowState.MAXIMIZED)) {
                friendlyURLPath = friendlyURLPath + "/" + windowState;
            }
        }
        return friendlyURLPath;
    }

    public String getMapping() {
        return _MAPPING;
    }

    public String getPortletId() {
        return _PORTLET_ID;
    }

    public void populateParams(String friendlyURLPath, Map<String, String[]> params) {
        this.addParam(params, "p_p_id", _PORTLET_ID);
        this.addParam(params, "p_p_lifecycle", "0");
        this.addParam(params, "p_p_mode", PortletMode.VIEW);
        int x = friendlyURLPath.indexOf("/", 1);
        int y = friendlyURLPath.indexOf("/", x + 1);
        if (y == -1) {
            y = friendlyURLPath.length();
        }
        if (x + 1 == friendlyURLPath.length()) {
            this.addParam(params, "struts_action", "/blogs/view");
            return;
        }
        String type = friendlyURLPath.substring(x + 1, y);
        if (type.equals("rss")) {
            this.addParam(params, "p_p_lifecycle", "1");
            this.addParam(params, "p_p_state", LiferayWindowState.EXCLUSIVE);
            this.addParam(params, "struts_action", "/blogs/rss");
        } else if (type.equals("trackback")) {
            this.addParam(params, "p_p_lifecycle", "1");
            this.addParam(params, "p_p_state", LiferayWindowState.EXCLUSIVE);
            this.addParam(params, "struts_action", "/blogs/trackback");
            type = friendlyURLPath.substring(y + 1);
            this.addParam(params, this.getEntryIdParam(type), type);
        } else {
            this.addParam(params, "struts_action", "/blogs/view_entry");
            this.addParam(params, this.getEntryIdParam(type), type);
        }
        if (friendlyURLPath.indexOf("maximized", x) != -1) {
            this.addParam(params, "p_p_state", WindowState.MAXIMIZED);
        }
    }

    protected String getEntryIdParam(String type) {
        if (Validator.isNumber((String)type)) {
            return "entryId";
        }
        return "urlTitle";
    }
}

