/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.lar;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.blogs.lar.WordPressImporter;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.persistence.BlogsEntryUtil;
import java.util.Calendar;
import java.util.List;
import javax.portlet.PortletPreferences;

public class BlogsPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "blogs";
    private static final PortletDataHandlerBoolean _entries = new PortletDataHandlerBoolean("blogs", "entries", true, true);
    private static final PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("blogs", "comments");
    private static final PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("blogs", "ratings");
    private static final PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("blogs", "tags");
    private static final PortletDataHandlerBoolean _wordpress = new PortletDataHandlerBoolean("blogs", "wordpress");

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            if (!context.addPrimaryKey(BlogsPortletDataHandlerImpl.class, "deleteData")) {
                BlogsEntryLocalServiceUtil.deleteEntries((long)context.getGroupId());
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("blogs-data");
            root.addAttribute("group-id", String.valueOf(context.getGroupId()));
            List entries = BlogsEntryUtil.findByGroupId((long)context.getGroupId());
            for (BlogsEntry entry : entries) {
                this.exportEntry(context, root, entry);
            }
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_entries, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_entries, _comments, _ratings, _tags, _wordpress};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List entryEls = root.elements("entry");
            for (Element entryEl : entryEls) {
                String path = entryEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                BlogsEntry entry = (BlogsEntry)context.getZipEntryAsObject(path);
                this.importEntry(context, entry);
            }
            if (context.getBooleanParameter(_NAMESPACE, "wordpress")) {
                WordPressImporter.importData(context);
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    protected void exportEntry(PortletDataContext context, Element root, BlogsEntry entry) throws SystemException {
        if (!context.isWithinDateRange(entry.getModifiedDate())) {
            return;
        }
        String path = this.getEntryPath(context, entry);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element entryEl = root.addElement("entry");
        entryEl.addAttribute("path", path);
        if (context.getBooleanParameter(_NAMESPACE, "comments")) {
            context.addComments(BlogsEntry.class, entry.getEntryId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.addRatingsEntries(BlogsEntry.class, entry.getEntryId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            context.addTagsEntries(BlogsEntry.class, entry.getEntryId());
        }
        entry.setUserUuid(entry.getUserUuid());
        context.addZipEntry(path, (Object)entry);
    }

    protected String getEntryPath(PortletDataContext context, BlogsEntry entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("33"));
        sb.append("/entries/");
        sb.append(entry.getEntryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected void importEntry(PortletDataContext context, BlogsEntry entry) throws Exception {
        long userId = context.getUserId(entry.getUserUuid());
        Calendar displayDateCal = CalendarFactoryUtil.getCalendar();
        displayDateCal.setTime(entry.getDisplayDate());
        int displayDateMonth = displayDateCal.get(2);
        int displayDateDay = displayDateCal.get(5);
        int displayDateYear = displayDateCal.get(1);
        int displayDateHour = displayDateCal.get(10);
        int displayDateMinute = displayDateCal.get(12);
        if (displayDateCal.get(9) == 1) {
            displayDateHour += 12;
        }
        boolean draft = entry.isDraft();
        boolean allowTrackbacks = entry.isAllowTrackbacks();
        String[] trackbacks = StringUtil.split((String)entry.getTrackbacks());
        String[] tagsEntries = null;
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            tagsEntries = context.getTagsEntries(BlogsEntry.class, entry.getEntryId());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(context.getGroupId());
        serviceContext.setTagsEntries(tagsEntries);
        BlogsEntry existingEntry = null;
        existingEntry = context.getDataStrategy().equals("DATA_STRATEGY_MIRROR") ? ((existingEntry = BlogsEntryUtil.fetchByUUID_G((String)entry.getUuid(), (long)context.getGroupId())) == null ? BlogsEntryLocalServiceUtil.addEntry((String)entry.getUuid(), (long)userId, (String)entry.getTitle(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)draft, (boolean)allowTrackbacks, (String[])trackbacks, (ServiceContext)serviceContext) : BlogsEntryLocalServiceUtil.updateEntry((long)userId, (long)existingEntry.getEntryId(), (String)entry.getTitle(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)draft, (boolean)allowTrackbacks, (String[])trackbacks, (ServiceContext)serviceContext)) : BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)entry.getTitle(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)draft, (boolean)allowTrackbacks, (String[])trackbacks, (ServiceContext)serviceContext);
        if (context.getBooleanParameter(_NAMESPACE, "comments")) {
            context.importComments(BlogsEntry.class, entry.getEntryId(), existingEntry.getEntryId(), context.getGroupId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.importRatingsEntries(BlogsEntry.class, entry.getEntryId(), existingEntry.getEntryId());
        }
    }
}

