/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.impl;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.EntryContentException;
import com.liferay.portlet.blogs.EntryDisplayDateException;
import com.liferay.portlet.blogs.EntryTitleException;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.base.BlogsEntryLocalServiceBaseImpl;
import com.liferay.portlet.blogs.util.BlogsUtil;
import com.liferay.portlet.blogs.util.Indexer;
import com.liferay.portlet.blogs.util.comparator.EntryDisplayDateComparator;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsEntryLocalServiceImpl
extends BlogsEntryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(BlogsEntryLocalServiceImpl.class);

    public BlogsEntry addEntry(long userId, String title, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean draft, boolean allowTrackbacks, String[] trackbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addEntry(null, userId, title, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, draft, allowTrackbacks, trackbacks, serviceContext);
    }

    public BlogsEntry addEntry(String uuid, long userId, String title, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean draft, boolean allowTrackbacks, String[] trackbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new EntryDisplayDateException());
        Date now = new Date();
        this.validate(title, content);
        long entryId = this.counterLocalService.increment();
        BlogsEntry entry = this.blogsEntryPersistence.create(entryId);
        entry.setUuid(uuid);
        entry.setGroupId(groupId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setCreateDate(now);
        entry.setModifiedDate(now);
        entry.setTitle(title);
        entry.setUrlTitle(this.getUniqueUrlTitle(entryId, groupId, title));
        entry.setContent(content);
        entry.setDisplayDate(displayDate);
        entry.setDraft(draft);
        entry.setAllowTrackbacks(allowTrackbacks);
        entry.setExpandoBridgeAttributes(serviceContext);
        this.blogsEntryPersistence.update((BaseModel)entry, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addEntryResources(entry, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addEntryResources(entry, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        if (!draft) {
            this.blogsStatsUserLocalService.updateStatsUser(groupId, userId, now);
        }
        if (PropsValues.BLOGS_ENTRY_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, entry.getUserName(), BlogsEntry.class.getName(), entryId);
        }
        if (!draft) {
            this.socialActivityLocalService.addUniqueActivity(userId, groupId, BlogsEntry.class.getName(), entryId, 2, "", 0L);
        }
        this.updateTagsAsset(userId, entry, serviceContext.getTagsEntries());
        this.reIndex(entry);
        this.notifySubscribers(entry, serviceContext);
        this.pingGoogle(entry, serviceContext);
        this.pingTrackbacks(entry, trackbacks, false, serviceContext);
        return entry;
    }

    public void addEntryResources(long entryId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, addCommunityPermissions, addGuestPermissions);
    }

    public void addEntryResources(BlogsEntry entry, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BlogsEntry.class.getName(), entry.getEntryId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addEntryResources(long entryId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, communityPermissions, guestPermissions);
    }

    public void addEntryResources(BlogsEntry entry, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BlogsEntry.class.getName(), entry.getEntryId(), communityPermissions, guestPermissions);
    }

    public void deleteEntries(long groupId) throws PortalException, SystemException {
        for (BlogsEntry entry : this.blogsEntryPersistence.findByGroupId(groupId)) {
            this.deleteEntry(entry);
        }
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public void deleteEntry(BlogsEntry entry) throws PortalException, SystemException {
        this.blogsEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource(entry.getCompanyId(), BlogsEntry.class.getName(), 4, entry.getEntryId());
        this.blogsStatsUserLocalService.updateStatsUser(entry.getGroupId(), entry.getUserId());
        this.expandoValueLocalService.deleteValues(BlogsEntry.class.getName(), entry.getEntryId());
        this.mbMessageLocalService.deleteDiscussionMessages(BlogsEntry.class.getName(), entry.getEntryId());
        this.ratingsStatsLocalService.deleteStats(BlogsEntry.class.getName(), entry.getEntryId());
        this.socialActivityLocalService.deleteActivities(BlogsEntry.class.getName(), entry.getEntryId());
        this.tagsAssetLocalService.deleteAsset(BlogsEntry.class.getName(), entry.getEntryId());
        try {
            Indexer.deleteEntry(entry.getCompanyId(), entry.getEntryId());
        }
        catch (SearchException se) {
            _log.error((Object)("Deleting index " + entry.getEntryId()), (Throwable)se);
        }
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, int start, int end) throws SystemException {
        return this.blogsEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.blogsEntryPersistence.findByCompanyId(companyId, start, end, obc);
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, boolean draft, int start, int end) throws SystemException {
        return this.blogsEntryPersistence.findByC_D_D(companyId, new Date(), draft, start, end);
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, boolean draft, int start, int end, OrderByComparator obc) throws SystemException {
        return this.blogsEntryPersistence.findByC_D_D(companyId, new Date(), draft, start, end, obc);
    }

    public int getCompanyEntriesCount(long companyId) throws SystemException {
        return this.blogsEntryPersistence.countByCompanyId(companyId);
    }

    public int getCompanyEntriesCount(long companyId, boolean draft) throws SystemException {
        return this.blogsEntryPersistence.countByC_D_D(companyId, new Date(), draft);
    }

    public BlogsEntry[] getEntriesPrevAndNext(long entryId) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        return this.blogsEntryPersistence.findByGroupId_PrevAndNext(entry.getEntryId(), entry.getGroupId(), (OrderByComparator)new EntryDisplayDateComparator(true));
    }

    public BlogsEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.blogsEntryPersistence.findByPrimaryKey(entryId);
    }

    public BlogsEntry getEntry(long groupId, String urlTitle) throws PortalException, SystemException {
        return this.blogsEntryPersistence.findByG_UT(groupId, urlTitle);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int start, int end) throws SystemException {
        return this.blogsEntryPersistence.findByGroupId(groupId, start, end);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.blogsEntryPersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, boolean draft, int start, int end) throws SystemException {
        return this.blogsEntryPersistence.findByG_D_D(groupId, new Date(), draft, start, end);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, boolean draft, int start, int end, OrderByComparator obc) throws SystemException {
        return this.blogsEntryPersistence.findByG_D_D(groupId, new Date(), draft, start, end, obc);
    }

    public int getGroupEntriesCount(long groupId) throws SystemException {
        return this.blogsEntryPersistence.countByGroupId(groupId);
    }

    public int getGroupEntriesCount(long groupId, boolean draft) throws SystemException {
        return this.blogsEntryPersistence.countByG_D_D(groupId, new Date(), draft);
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, int start, int end) throws SystemException {
        return this.blogsEntryPersistence.findByG_U(groupId, userId, start, end);
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.blogsEntryPersistence.findByG_U(groupId, userId, start, end, obc);
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, boolean draft, int start, int end) throws SystemException {
        return this.blogsEntryPersistence.findByG_U_D_D(groupId, userId, new Date(), draft, start, end);
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, boolean draft, int start, int end, OrderByComparator obc) throws SystemException {
        return this.blogsEntryPersistence.findByG_U_D_D(groupId, userId, new Date(), draft, start, end, obc);
    }

    public int getGroupUserEntriesCount(long groupId, long userId) throws SystemException {
        return this.blogsEntryPersistence.countByG_U(groupId, userId);
    }

    public int getGroupUserEntriesCount(long groupId, long userId, boolean draft) throws SystemException {
        return this.blogsEntryPersistence.countByG_U_D_D(groupId, userId, new Date(), draft);
    }

    public List<BlogsEntry> getNoAssetEntries() throws SystemException {
        return this.blogsEntryFinder.findByNoAssets();
    }

    public List<BlogsEntry> getOrganizationEntries(long organizationId, boolean draft, int start, int end) throws SystemException {
        return this.blogsEntryFinder.findByOrganizationId(organizationId, new Date(), draft, start, end);
    }

    public int getOrganizationEntriesCount(long organizationId, boolean draft) throws SystemException {
        return this.blogsEntryFinder.countByOrganizationId(organizationId, new Date(), draft);
    }

    public String getUrlTitle(long entryId, String title) {
        return BlogsUtil.getUrlTitle(entryId, title);
    }

    public void reIndex(long entryId) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        BlogsEntry entry = this.blogsEntryPersistence.fetchByPrimaryKey(entryId);
        if (entry == null) {
            return;
        }
        this.reIndex(entry);
    }

    public void reIndex(BlogsEntry entry) throws SystemException {
        if (entry.isDraft()) {
            return;
        }
        long companyId = entry.getCompanyId();
        long groupId = entry.getGroupId();
        long userId = entry.getUserId();
        String userName = entry.getUserName();
        long entryId = entry.getEntryId();
        String title = entry.getTitle();
        String content = entry.getContent();
        Date displayDate = entry.getDisplayDate();
        String[] tagsEntries = this.tagsEntryLocalService.getEntryNames(BlogsEntry.class.getName(), entryId);
        ExpandoBridge expandoBridge = entry.getExpandoBridge();
        try {
            Indexer.updateEntry(companyId, groupId, userId, userName, entryId, title, content, displayDate, tagsEntries, expandoBridge);
        }
        catch (SearchException se) {
            _log.error((Object)("Reindexing " + entryId), (Throwable)se);
        }
    }

    public void reIndex(String[] ids) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        long companyId = GetterUtil.getLong((String)ids[0]);
        try {
            this.reIndexEntries(companyId);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Hits search(long companyId, long groupId, long userId, long ownerUserId, String keywords, int start, int end) throws SystemException {
        try {
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            contextQuery.addRequiredTerm("portletId", "33");
            if (groupId > 0L) {
                Group group = this.groupLocalService.getGroup(groupId);
                if (group.isLayout()) {
                    contextQuery.addRequiredTerm("scopeGroupId", groupId);
                    groupId = group.getParentGroupId();
                }
                contextQuery.addRequiredTerm("groupId", groupId);
            }
            if (ownerUserId > 0L) {
                contextQuery.addRequiredTerm("userId", ownerUserId);
            }
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            if (Validator.isNotNull((String)keywords)) {
                searchQuery.addTerm("userName", keywords);
                searchQuery.addTerm("title", keywords);
                searchQuery.addTerm("content", keywords);
                searchQuery.addTerm("tagsEntries", keywords, true);
            }
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (searchQuery.clauses().size() > 0) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)companyId, (long)groupId, (long)userId, (String)BlogsEntry.class.getName(), (Query)fullQuery, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public BlogsEntry updateEntry(long userId, long entryId, String title, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean draft, boolean allowTrackbacks, String[] trackbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new EntryDisplayDateException());
        this.validate(title, content);
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        String oldUrlTitle = entry.getUrlTitle();
        entry.setModifiedDate(new Date());
        entry.setTitle(title);
        entry.setUrlTitle(this.getUniqueUrlTitle(entryId, entry.getGroupId(), title));
        entry.setContent(content);
        entry.setDisplayDate(displayDate);
        entry.setDraft(draft);
        entry.setAllowTrackbacks(allowTrackbacks);
        entry.setExpandoBridgeAttributes(serviceContext);
        this.blogsEntryPersistence.update((BaseModel)entry, false);
        if (serviceContext.getCommunityPermissions() != null || serviceContext.getGuestPermissions() != null) {
            this.updateEntryResources(entry, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        if (!draft) {
            this.blogsStatsUserLocalService.updateStatsUser(entry.getGroupId(), entry.getUserId(), displayDate);
        }
        if (!draft) {
            this.socialActivityLocalService.addUniqueActivity(userId, entry.getGroupId(), BlogsEntry.class.getName(), entryId, 2, "", 0L);
        }
        this.updateTagsAsset(userId, entry, serviceContext.getTagsEntries());
        if (!draft) {
            this.reIndex(entry);
        } else {
            try {
                Indexer.deleteEntry(entry.getCompanyId(), entryId);
            }
            catch (SearchException se) {
                _log.error((Object)("Deleting index " + entry.getEntryId()), (Throwable)se);
            }
        }
        this.notifySubscribers(entry, serviceContext);
        this.pingGoogle(entry, serviceContext);
        boolean pingOldTrackbacks = false;
        if (!oldUrlTitle.equals(entry.getUrlTitle())) {
            pingOldTrackbacks = true;
        }
        this.pingTrackbacks(entry, trackbacks, pingOldTrackbacks, serviceContext);
        return entry;
    }

    public void updateEntryResources(BlogsEntry entry, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.updateResources(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), communityPermissions, guestPermissions);
    }

    public void updateTagsAsset(long userId, BlogsEntry entry, String[] tagsEntries) throws PortalException, SystemException {
        this.tagsAssetLocalService.updateAsset(userId, entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), null, tagsEntries, !entry.isDraft(), null, null, entry.getDisplayDate(), null, "text/html", entry.getTitle(), null, null, null, 0, 0, null, false);
    }

    protected String getUniqueUrlTitle(long entryId, long groupId, String title) throws SystemException {
        BlogsEntry entry;
        String urlTitle;
        String newUrlTitle = urlTitle = BlogsUtil.getUrlTitle(entryId, title);
        int i = 1;
        while ((entry = this.blogsEntryPersistence.fetchByG_UT(groupId, newUrlTitle)) != null && entry.getEntryId() != entryId) {
            newUrlTitle = urlTitle + "-" + i;
            ++i;
        }
        return newUrlTitle;
    }

    protected void notifySubscribers(BlogsEntry entry, ServiceContext serviceContext) throws PortalException, SystemException {
        if (entry.isDraft()) {
            return;
        }
        String layoutFullURL = PortalUtil.getLayoutFullURL((long)serviceContext.getScopeGroupId(), (String)"33");
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = entry.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "33";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(entry.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(serviceContext.isCommandAdd() && BlogsUtil.getEmailEntryAddedEnabled(preferences) || serviceContext.isCommandUpdate() && BlogsUtil.getEmailEntryUpdatedEnabled(preferences))) {
            return;
        }
        Company company = this.companyPersistence.findByPrimaryKey(entry.getCompanyId());
        Group group = this.groupPersistence.findByPrimaryKey(serviceContext.getScopeGroupId());
        String emailAddress = "";
        String fullName = entry.getUserName();
        try {
            User user = this.userPersistence.findByPrimaryKey(entry.getUserId());
            emailAddress = user.getEmailAddress();
            fullName = user.getFullName();
        }
        catch (NoSuchUserException nsue) {
            // empty catch block
        }
        String portletName = PortalUtil.getPortletTitle((String)"33", (Locale)LocaleUtil.getDefault());
        String fromName = BlogsUtil.getEmailFromName(preferences);
        String fromAddress = BlogsUtil.getEmailFromAddress(preferences);
        fromName = StringUtil.replace((String)fromName, (String[])new String[]{"[$BLOGS_ENTRY_USER_ADDRESS$]", "[$BLOGS_ENTRY_USER_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{emailAddress, fullName, String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), portletName});
        fromAddress = StringUtil.replace((String)fromAddress, (String[])new String[]{"[$BLOGS_ENTRY_USER_ADDRESS$]", "[$BLOGS_ENTRY_USER_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{emailAddress, fullName, String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), portletName});
        String entryURL = layoutFullURL + "/-/" + "blogs" + "/" + entry.getEntryId();
        String subject = null;
        String body = null;
        if (serviceContext.isCommandUpdate()) {
            subject = BlogsUtil.getEmailEntryUpdatedSubject(preferences);
            body = BlogsUtil.getEmailEntryUpdatedBody(preferences);
        } else {
            subject = BlogsUtil.getEmailEntryAddedSubject(preferences);
            body = BlogsUtil.getEmailEntryAddedBody(preferences);
        }
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$BLOGS_ENTRY_USER_ADDRESS$]", "[$BLOGS_ENTRY_USER_NAME$]", "[$BLOGS_ENTRY_URL$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{emailAddress, fullName, entryURL, String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), fromAddress, fromName, company.getVirtualHost(), portletName});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$BLOGS_ENTRY_USER_ADDRESS$]", "[$BLOGS_ENTRY_USER_NAME$]", "[$BLOGS_ENTRY_URL$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{emailAddress, fullName, entryURL, String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), fromAddress, fromName, company.getVirtualHost(), portletName});
        Message message = new Message();
        message.put("companyId", (Object)entry.getCompanyId());
        message.put("userId", (Object)entry.getUserId());
        message.put("groupId", (Object)entry.getGroupId());
        message.put("entryId", (Object)entry.getEntryId());
        message.put("fromName", (Object)fromName);
        message.put("fromAddress", (Object)fromAddress);
        message.put("subject", (Object)subject);
        message.put("body", (Object)body);
        message.put("replyToAddress", (Object)fromAddress);
        message.put("mailId", (Object)BlogsUtil.getMailId(company.getMx(), entry.getEntryId()));
        message.put("htmlFormat", (Object)Boolean.TRUE);
        MessageBusUtil.sendMessage((String)"liferay/blogs", (Message)message);
    }

    protected void pingGoogle(BlogsEntry entry, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!PropsValues.BLOGS_PING_GOOGLE_ENABLED || !entry.isApproved()) {
            return;
        }
        String layoutFullURL = PortalUtil.getLayoutFullURL((long)serviceContext.getScopeGroupId(), (String)"33");
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        Group group = this.groupPersistence.findByPrimaryKey(entry.getGroupId());
        StringBuilder sb = new StringBuilder();
        String name = group.getDescriptiveName();
        String url = layoutFullURL + "/-/" + "blogs";
        String changesURL = layoutFullURL + "/-/" + "blogs/rss";
        sb.append("http://blogsearch.google.com/ping?name=");
        sb.append(HttpUtil.encodeURL((String)name));
        sb.append("&url=");
        sb.append(HttpUtil.encodeURL((String)url));
        sb.append("&changesURL=");
        sb.append(HttpUtil.encodeURL((String)changesURL));
        String location = sb.toString();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Pinging Google at " + location));
        }
        try {
            String response = HttpUtil.URLtoString((String)sb.toString());
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Google ping response: " + response));
            }
        }
        catch (IOException ioe) {
            _log.error((Object)("Unable to ping Google at " + location), (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pingTrackback(String trackback, Map<String, String> parts) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Pinging trackback " + trackback));
        }
        Http.Options options = new Http.Options();
        options.setLocation(trackback);
        options.setParts(parts);
        options.setPost(true);
        String xml = HttpUtil.URLtoString((Http.Options)options);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)xml);
        }
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
        String error = xml;
        try {
            xmlStreamReader.nextTag();
            xmlStreamReader.nextTag();
            String name = xmlStreamReader.getLocalName();
            if (name.equals("error")) {
                int status = GetterUtil.getInteger((String)xmlStreamReader.getElementText(), (int)1);
                if (status == 0) {
                    boolean bl = true;
                    return bl;
                }
                xmlStreamReader.nextTag();
                name = xmlStreamReader.getLocalName();
                if (name.equals("message")) {
                    error = xmlStreamReader.getElementText();
                }
            }
        }
        finally {
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception e) {}
            }
        }
        _log.error((Object)("Error while pinging trackback at " + trackback + ": " + error));
        return false;
    }

    protected void pingTrackbacks(BlogsEntry entry, String[] trackbacks, boolean pingOldTrackbacks, ServiceContext serviceContext) throws SystemException {
        if (!(PropsValues.BLOGS_TRACKBACK_ENABLED && entry.isAllowTrackbacks() && entry.isApproved())) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        HashMap<String, String> parts = new HashMap<String, String>();
        String excerpt = StringUtil.shorten((String)HtmlUtil.extractText((String)entry.getContent()), (int)PropsValues.BLOGS_TRACKBACK_EXCERPT_LENGTH);
        String url = layoutFullURL + "/-/" + "blogs/" + entry.getUrlTitle();
        parts.put("title", entry.getTitle());
        parts.put("excerpt", excerpt);
        parts.put("url", url);
        parts.put("blog_name", entry.getUserName());
        HashSet trackbacksSet = null;
        trackbacksSet = Validator.isNotNull((Object[])trackbacks) ? SetUtil.fromArray((Object[])trackbacks) : new HashSet();
        if (pingOldTrackbacks) {
            trackbacksSet.addAll(SetUtil.fromArray((Object[])StringUtil.split((String)entry.getTrackbacks())));
            entry.setTrackbacks("");
            this.blogsEntryPersistence.update((BaseModel)entry, false);
        }
        Set oldTrackbacks = SetUtil.fromArray((Object[])StringUtil.split((String)entry.getTrackbacks()));
        HashSet<String> validTrackbacks = new HashSet<String>();
        for (String trackback : trackbacksSet) {
            if (oldTrackbacks.contains(trackback)) continue;
            try {
                if (!this.pingTrackback(trackback, parts)) continue;
                validTrackbacks.add(trackback);
            }
            catch (Exception e) {
                _log.error((Object)("Error while pinging trackback at " + trackback), (Throwable)e);
            }
        }
        if (!validTrackbacks.isEmpty()) {
            String newTrackbacks = StringUtil.merge(validTrackbacks);
            if (Validator.isNotNull((String)entry.getTrackbacks())) {
                newTrackbacks = newTrackbacks + "," + entry.getTrackbacks();
            }
            entry.setTrackbacks(newTrackbacks);
            this.blogsEntryPersistence.update((BaseModel)entry, false);
        }
    }

    protected void reIndexEntries(long companyId) throws SystemException {
        int count = this.blogsEntryPersistence.countByCompanyId(companyId);
        int pages = count / 1000;
        for (int i = 0; i <= pages; ++i) {
            int start = i * 1000;
            int end = start + 1000;
            this.reIndexEntries(companyId, start, end);
        }
    }

    protected void reIndexEntries(long companyId, int start, int end) throws SystemException {
        List entries = this.blogsEntryPersistence.findByCompanyId(companyId, start, end);
        for (BlogsEntry entry : entries) {
            this.reIndex(entry);
        }
    }

    protected void validate(String title, String content) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new EntryTitleException();
        }
        if (Validator.isNull((String)content)) {
            throw new EntryContentException();
        }
    }
}

