/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;

public class BlogsEntryPermission {
    public static void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        if (!BlogsEntryPermission.contains(permissionChecker, entryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, BlogsEntry entry, String actionId) throws PortalException {
        if (!BlogsEntryPermission.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)entryId);
        return BlogsEntryPermission.contains(permissionChecker, entry, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, BlogsEntry entry, String actionId) {
        if (permissionChecker.hasOwnerPermission(entry.getCompanyId(), BlogsEntry.class.getName(), entry.getEntryId(), entry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), actionId);
    }
}

