/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.persistence;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.model.impl.BlogsEntryImpl;
import com.liferay.portlet.blogs.service.persistence.BlogsEntryFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsEntryFinderImpl
extends BasePersistenceImpl<BlogsEntry>
implements BlogsEntryFinder {
    public static String COUNT_BY_ORGANIZATION_IDS = BlogsEntryFinder.class.getName() + ".countByOrganizationIds";
    public static String FIND_BY_ORGANIZATION_IDS = BlogsEntryFinder.class.getName() + ".findByOrganizationIds";
    public static String FIND_BY_NO_ASSETS = BlogsEntryFinder.class.getName() + ".findByNoAssets";

    public int countByOrganizationId(long organizationId, Date displayDate, boolean draft) throws SystemException {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.countByOrganizationIds(organizationIds, displayDate, draft);
    }

    public int countByOrganizationIds(List<Long> organizationIds, Date displayDate, boolean draft) throws SystemException {
        Timestamp displayDate_TS = CalendarUtil.getTimestamp((Date)displayDate);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < organizationIds.size(); ++i) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
            }
            qPos.add(displayDate_TS);
            qPos.add(draft);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByOrganizationId(long organizationId, Date displayDate, boolean draft, int start, int end) throws SystemException {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.findByOrganizationIds(organizationIds, displayDate, draft, start, end);
    }

    public List<BlogsEntry> findByOrganizationIds(List<Long> organizationIds, Date displayDate, boolean draft, int start, int end) throws SystemException {
        Timestamp displayDate_TS = CalendarUtil.getTimestamp((Date)displayDate);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ORGANIZATION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("BlogsEntry", BlogsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < organizationIds.size(); ++i) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
            }
            qPos.add(displayDate_TS);
            qPos.add(draft);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("BlogsEntry", BlogsEntryImpl.class);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getOrganizationIds(List<Long> organizationIds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < organizationIds.size(); ++i) {
            sb.append("Users_Orgs.organizationId = ? ");
            if (i + 1 == organizationIds.size()) continue;
            sb.append("OR ");
        }
        return sb.toString();
    }
}

