/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.persistence;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.blogs.model.BlogsStatsUser;
import com.liferay.portlet.blogs.model.impl.BlogsStatsUserImpl;
import com.liferay.portlet.blogs.service.persistence.BlogsStatsUserFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsStatsUserFinderImpl
extends BasePersistenceImpl<BlogsStatsUser>
implements BlogsStatsUserFinder {
    public static String COUNT_BY_ORGANIZATION_IDS = BlogsStatsUserFinder.class.getName() + ".countByOrganizationIds";
    public static String FIND_BY_ORGANIZATION_IDS = BlogsStatsUserFinder.class.getName() + ".findByOrganizationIds";

    public int countByOrganizationId(long organizationId) throws SystemException {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.countByOrganizationIds(organizationIds);
    }

    public int countByOrganizationIds(List<Long> organizationIds) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < organizationIds.size(); ++i) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
            }
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsStatsUser> findByOrganizationId(long organizationId, int start, int end, OrderByComparator obc) throws SystemException {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.findByOrganizationIds(organizationIds, start, end, obc);
    }

    public List<BlogsStatsUser> findByOrganizationIds(List<Long> organizationIds, int start, int end, OrderByComparator obc) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ORGANIZATION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("BlogsStatsUser", BlogsStatsUserImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < organizationIds.size(); ++i) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getOrganizationIds(List<Long> organizationIds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < organizationIds.size(); ++i) {
            sb.append("Users_Orgs.organizationId = ? ");
            if (i + 1 == organizationIds.size()) continue;
            sb.append("OR ");
        }
        return sb.toString();
    }
}

