/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.FriendlyURLNormalizer;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletPreferences;

public class BlogsUtil {
    public static final String POP_PORTLET_PREFIX = "blogs.";
    private static final char[] _URL_TITLE_REPLACE_CHARS = new char[]{'.', '/'};

    public static String getEmailEntryAddedBody(PortletPreferences preferences) {
        String emailEntryAddedBody = preferences.getValue("email-entry-added-body", "");
        if (Validator.isNotNull((String)emailEntryAddedBody)) {
            return emailEntryAddedBody;
        }
        return ContentUtil.get(PropsUtil.get("blogs.email.entry.added.body"));
    }

    public static boolean getEmailEntryAddedEnabled(PortletPreferences preferences) {
        String emailEntryAddedEnabled = preferences.getValue("email-entry-added-enabled", "");
        if (Validator.isNotNull((String)emailEntryAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailEntryAddedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("blogs.email.entry.added.enabled"));
    }

    public static String getEmailEntryAddedSubject(PortletPreferences preferences) {
        String emailEntryAddedSubject = preferences.getValue("email-entry-added-subject", "");
        if (Validator.isNotNull((String)emailEntryAddedSubject)) {
            return emailEntryAddedSubject;
        }
        return ContentUtil.get(PropsUtil.get("blogs.email.entry.added.subject"));
    }

    public static String getEmailEntryUpdatedBody(PortletPreferences preferences) {
        String emailEntryUpdatedBody = preferences.getValue("email-entry-updated-body", "");
        if (Validator.isNotNull((String)emailEntryUpdatedBody)) {
            return emailEntryUpdatedBody;
        }
        return ContentUtil.get(PropsUtil.get("blogs.email.entry.updated.body"));
    }

    public static boolean getEmailEntryUpdatedEnabled(PortletPreferences preferences) {
        String emailEntryUpdatedEnabled = preferences.getValue("email-entry-updated-enabled", "");
        if (Validator.isNotNull((String)emailEntryUpdatedEnabled)) {
            return GetterUtil.getBoolean((String)emailEntryUpdatedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("blogs.email.entry.updated.enabled"));
    }

    public static String getEmailEntryUpdatedSubject(PortletPreferences preferences) {
        String emailEntryUpdatedSubject = preferences.getValue("email-entry-updated-subject", "");
        if (Validator.isNotNull((String)emailEntryUpdatedSubject)) {
            return emailEntryUpdatedSubject;
        }
        return ContentUtil.get(PropsUtil.get("blogs.email.entry.updated.subject"));
    }

    public static String getEmailFromAddress(PortletPreferences preferences) {
        String emailFromAddress = PropsUtil.get("blogs.email.from.address");
        return preferences.getValue("email-from-address", emailFromAddress);
    }

    public static String getEmailFromName(PortletPreferences preferences) {
        String emailFromName = PropsUtil.get("blogs.email.from.name");
        return preferences.getValue("email-from-name", emailFromName);
    }

    public static String getMailId(String mx, long entryId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(POP_PORTLET_PREFIX);
        sb.append(entryId);
        sb.append("@");
        sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
        sb.append(".");
        sb.append(mx);
        sb.append(">");
        return sb.toString();
    }

    public static String getUrlTitle(long entryId, String title) {
        if (Validator.isNull((String)(title = title.trim().toLowerCase())) || Validator.isNumber((String)title) || title.equals("rss")) {
            return String.valueOf(entryId);
        }
        return FriendlyURLNormalizer.normalize(title, _URL_TITLE_REPLACE_CHARS);
    }
}

