/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.DocumentSummary;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import java.util.Date;
import javax.portlet.PortletURL;

public class Indexer
implements com.liferay.portal.kernel.search.Indexer {
    public static final String PORTLET_ID = "33";
    private static final String[] _CLASS_NAMES = new String[]{BlogsEntry.class.getName()};

    public static void addEntry(long companyId, long groupId, long userId, String userName, long entryId, String title, String content, Date displayDate, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getEntryDocument(companyId, groupId, userId, userName, entryId, title, content, displayDate, tagsEntries, expandoBridge);
        SearchEngineUtil.addDocument((long)companyId, (Document)doc);
    }

    public static void deleteEntry(long companyId, long entryId) throws SearchException {
        SearchEngineUtil.deleteDocument((long)companyId, (String)Indexer.getEntryUID(entryId));
    }

    public static Document getEntryDocument(long companyId, long groupId, long userId, String userName, long entryId, String title, String content, Date displayDate, String[] tagsEntries, ExpandoBridge expandoBridge) {
        long scopeGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                groupId = group.getParentGroupId();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        userName = PortalUtil.getUserName((long)userId, (String)userName);
        content = HtmlUtil.extractText((String)content);
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, entryId);
        doc.addModifiedDate(displayDate);
        doc.addKeyword("companyId", companyId);
        doc.addKeyword("portletId", PORTLET_ID);
        doc.addKeyword("groupId", groupId);
        doc.addKeyword("scopeGroupId", scopeGroupId);
        doc.addKeyword("userId", userId);
        doc.addText("userName", userName);
        doc.addText("title", title);
        doc.addText("content", content);
        doc.addKeyword("tagsEntries", tagsEntries);
        doc.addKeyword("entryClassName", BlogsEntry.class.getName());
        doc.addKeyword("entryClassPK", entryId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)doc, (ExpandoBridge)expandoBridge);
        return doc;
    }

    public static String getEntryUID(long entryId) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, entryId);
        return doc.get("uid");
    }

    public static void updateEntry(long companyId, long groupId, long userId, String userName, long entryId, String title, String content, Date displayDate, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getEntryDocument(companyId, groupId, userId, userName, entryId, title, content, displayDate, tagsEntries, expandoBridge);
        SearchEngineUtil.updateDocument((long)companyId, (String)doc.get("uid"), (Document)doc);
    }

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    public DocumentSummary getDocumentSummary(Document doc, String snippet, PortletURL portletURL) {
        String title = doc.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)doc.get("content"), (int)200);
        }
        String entryId = doc.get("entryClassPK");
        portletURL.setParameter("struts_action", "/blogs/view_entry");
        portletURL.setParameter("entryId", entryId);
        return new DocumentSummary(title, content, portletURL);
    }

    public void reIndex(String className, long classPK) throws SearchException {
        try {
            BlogsEntryLocalServiceUtil.reIndex((long)classPK);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void reIndex(String[] ids) throws SearchException {
        try {
            BlogsEntryLocalServiceUtil.reIndex((String[])ids);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }
}

