/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.bookmarks.EntryURLException;
import com.liferay.portlet.bookmarks.NoSuchEntryException;
import com.liferay.portlet.bookmarks.NoSuchFolderException;
import com.liferay.portlet.bookmarks.action.ActionUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryServiceUtil;
import com.liferay.portlet.tags.TagsEntryException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateEntry(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteEntry(actionRequest);
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
            LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
            if (layoutTypePortlet.hasPortletId(portletConfig.getPortletName())) {
                this.sendRedirect(actionRequest, actionResponse);
            } else {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                actionResponse.sendRedirect(redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.bookmarks.error");
            }
            if (e instanceof EntryURLException || e instanceof NoSuchFolderException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof TagsEntryException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getEntry(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.bookmarks.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.bookmarks.edit_entry"));
    }

    protected void deleteEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        BookmarksEntryServiceUtil.deleteEntry((long)entryId);
    }

    protected void updateEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
        String comments = ParamUtil.getString((PortletRequest)actionRequest, (String)"comments");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BookmarksEntry.class.getName(), (PortletRequest)actionRequest);
        if (entryId <= 0L) {
            BookmarksEntry entry = BookmarksEntryServiceUtil.addEntry((long)folderId, (String)name, (String)url, (String)comments, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection(actionRequest, BookmarksEntry.class.getName(), entry.getEntryId(), -1);
        } else {
            BookmarksEntryServiceUtil.updateEntry((long)entryId, (long)folderId, (String)name, (String)url, (String)comments, (ServiceContext)serviceContext);
        }
        AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, BookmarksEntry.class.getName(), folderId);
    }
}

