/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.lar;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.NoSuchEntryException;
import com.liferay.portlet.bookmarks.NoSuchFolderException;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksEntryUtil;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksFolderUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "bookmarks";
    private static final PortletDataHandlerBoolean _foldersAndEntries = new PortletDataHandlerBoolean("bookmarks", "folders-and-entries", true, true);
    private static final PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("bookmarks", "tags");
    private static Log _log = LogFactoryUtil.getLog(BookmarksPortletDataHandlerImpl.class);

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            if (!context.addPrimaryKey(BookmarksPortletDataHandlerImpl.class, "deleteData")) {
                BookmarksFolderLocalServiceUtil.deleteFolders((long)context.getGroupId());
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("bookmarks-data");
            root.addAttribute("group-id", String.valueOf(context.getGroupId()));
            Element foldersEl = root.addElement("folders");
            Element entriesEl = root.addElement("entries");
            List folders = BookmarksFolderUtil.findByGroupId((long)context.getGroupId());
            for (BookmarksFolder folder : folders) {
                this.exportFolder(context, foldersEl, entriesEl, folder);
            }
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_foldersAndEntries, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_foldersAndEntries, _tags};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List folderEls = root.element("folders").elements("folder");
            Map folderPKs = context.getNewPrimaryKeysMap(BookmarksFolder.class);
            for (Element folderEl : folderEls) {
                String path = folderEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                BookmarksFolder folder = (BookmarksFolder)context.getZipEntryAsObject(path);
                this.importFolder(context, folderPKs, folder);
            }
            List entryEls = root.element("entries").elements("entry");
            for (Element entryEl : entryEls) {
                String path = entryEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                BookmarksEntry entry = (BookmarksEntry)context.getZipEntryAsObject(path);
                this.importEntry(context, folderPKs, entry);
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    protected void exportFolder(PortletDataContext context, Element foldersEl, Element entriesEl, BookmarksFolder folder) throws PortalException, SystemException {
        if (context.isWithinDateRange(folder.getModifiedDate())) {
            this.exportParentFolder(context, foldersEl, folder.getParentFolderId());
            String path = this.getFolderPath(context, folder);
            if (context.isPathNotProcessed(path)) {
                Element folderEl = foldersEl.addElement("folder");
                folderEl.addAttribute("path", path);
                folder.setUserUuid(folder.getUserUuid());
                context.addZipEntry(path, (Object)folder);
            }
        }
        List entries = BookmarksEntryUtil.findByFolderId((long)folder.getFolderId());
        for (BookmarksEntry entry : entries) {
            this.exportEntry(context, foldersEl, entriesEl, entry);
        }
    }

    protected void exportEntry(PortletDataContext context, Element foldersEl, Element entriesEl, BookmarksEntry entry) throws PortalException, SystemException {
        if (!context.isWithinDateRange(entry.getModifiedDate())) {
            return;
        }
        this.exportParentFolder(context, foldersEl, entry.getFolderId());
        String path = this.getEntryPath(context, entry);
        if (context.isPathNotProcessed(path)) {
            Element entryEl = entriesEl.addElement("entry");
            entryEl.addAttribute("path", path);
            if (context.getBooleanParameter(_NAMESPACE, "tags")) {
                context.addTagsEntries(BookmarksEntry.class, entry.getEntryId());
            }
            entry.setUserUuid(entry.getUserUuid());
            context.addZipEntry(path, (Object)entry);
        }
    }

    protected void exportParentFolder(PortletDataContext context, Element foldersEl, long folderId) throws PortalException, SystemException {
        if (folderId == 0L) {
            return;
        }
        BookmarksFolder folder = BookmarksFolderUtil.findByPrimaryKey((long)folderId);
        this.exportParentFolder(context, foldersEl, folder.getParentFolderId());
        String path = this.getFolderPath(context, folder);
        if (context.isPathNotProcessed(path)) {
            Element folderEl = foldersEl.addElement("folder");
            folderEl.addAttribute("path", path);
            folder.setUserUuid(folder.getUserUuid());
            context.addZipEntry(path, (Object)folder);
        }
    }

    protected String getEntryPath(PortletDataContext context, BookmarksEntry entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("28"));
        sb.append("/entries/");
        sb.append(entry.getEntryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getFolderPath(PortletDataContext context, BookmarksFolder folder) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("28"));
        sb.append("/folders/");
        sb.append(folder.getFolderId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getImportFolderPath(PortletDataContext context, long folderId) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getSourcePortletPath("28"));
        sb.append("/folders/");
        sb.append(folderId);
        sb.append(".xml");
        return sb.toString();
    }

    protected void importEntry(PortletDataContext context, Map<Long, Long> folderPKs, BookmarksEntry entry) throws Exception {
        long userId = context.getUserId(entry.getUserUuid());
        long folderId = MapUtil.getLong(folderPKs, (long)entry.getFolderId(), (long)entry.getFolderId());
        String[] tagsEntries = null;
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            tagsEntries = context.getTagsEntries(BookmarksEntry.class, entry.getEntryId());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setTagsEntries(tagsEntries);
        if (folderId != 0L && folderId == entry.getFolderId()) {
            String path = this.getImportFolderPath(context, folderId);
            BookmarksFolder folder = (BookmarksFolder)context.getZipEntryAsObject(path);
            this.importFolder(context, folderPKs, folder);
            folderId = MapUtil.getLong(folderPKs, (long)entry.getFolderId(), (long)entry.getFolderId());
        }
        BookmarksEntry existingEntry = null;
        try {
            BookmarksFolderUtil.findByPrimaryKey((long)folderId);
            if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
                try {
                    existingEntry = BookmarksEntryUtil.findByUUID_G((String)entry.getUuid(), (long)context.getGroupId());
                    BookmarksEntryLocalServiceUtil.updateEntry((long)userId, (long)existingEntry.getEntryId(), (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getComments(), (ServiceContext)serviceContext);
                }
                catch (NoSuchEntryException nsee) {
                    BookmarksEntryLocalServiceUtil.addEntry((String)entry.getUuid(), (long)userId, (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getComments(), (ServiceContext)serviceContext);
                }
            } else {
                BookmarksEntryLocalServiceUtil.addEntry((long)userId, (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getComments(), (ServiceContext)serviceContext);
            }
        }
        catch (NoSuchFolderException nsfe) {
            _log.error((Object)("Could not find the parent folder for entry " + entry.getEntryId()));
        }
    }

    protected void importFolder(PortletDataContext context, Map<Long, Long> folderPKs, BookmarksFolder folder) throws Exception {
        long userId = context.getUserId(folder.getUserUuid());
        long parentFolderId = MapUtil.getLong(folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        if (parentFolderId != 0L && parentFolderId == folder.getParentFolderId()) {
            String path = this.getImportFolderPath(context, parentFolderId);
            BookmarksFolder parentFolder = (BookmarksFolder)context.getZipEntryAsObject(path);
            this.importFolder(context, folderPKs, parentFolder);
            parentFolderId = MapUtil.getLong(folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        }
        BookmarksFolder existingFolder = null;
        try {
            if (parentFolderId != 0L) {
                BookmarksFolderUtil.findByPrimaryKey((long)parentFolderId);
            }
            existingFolder = context.getDataStrategy().equals("DATA_STRATEGY_MIRROR") ? ((existingFolder = BookmarksFolderUtil.fetchByUUID_G((String)folder.getUuid(), (long)context.getGroupId())) == null ? BookmarksFolderLocalServiceUtil.addFolder((String)folder.getUuid(), (long)userId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext) : BookmarksFolderLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (boolean)false, (ServiceContext)serviceContext)) : BookmarksFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
            folderPKs.put(folder.getFolderId(), existingFolder.getFolderId());
        }
        catch (NoSuchFolderException nsfe) {
            _log.error((Object)("Could not find the parent folder for folder " + folder.getFolderId()));
        }
    }
}

