/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.EntryURLException;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.base.BookmarksEntryLocalServiceBaseImpl;
import com.liferay.portlet.bookmarks.util.Indexer;
import com.liferay.portlet.bookmarks.util.comparator.EntryModifiedDateComparator;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksEntryLocalServiceImpl
extends BookmarksEntryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(BookmarksEntryLocalServiceImpl.class);

    public BookmarksEntry addEntry(long userId, long folderId, String name, String url, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addEntry(null, userId, folderId, name, url, comments, serviceContext);
    }

    public BookmarksEntry addEntry(String uuid, long userId, long folderId, String name, String url, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        if (Validator.isNull((String)name)) {
            name = url;
        }
        Date now = new Date();
        this.validate(url);
        long entryId = this.counterLocalService.increment();
        BookmarksEntry entry = this.bookmarksEntryPersistence.create(entryId);
        entry.setUuid(uuid);
        entry.setGroupId(folder.getGroupId());
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setCreateDate(now);
        entry.setModifiedDate(now);
        entry.setFolderId(folderId);
        entry.setName(name);
        entry.setUrl(url);
        entry.setComments(comments);
        entry.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksEntryPersistence.update((BaseModel)entry, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addEntryResources(entry, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addEntryResources(entry, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        this.updateTagsAsset(userId, entry, serviceContext.getTagsEntries());
        this.reIndex(entry);
        return entry;
    }

    public void addEntryResources(BookmarksEntry entry, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BookmarksEntry.class.getName(), entry.getEntryId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addEntryResources(BookmarksEntry entry, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BookmarksEntry.class.getName(), entry.getEntryId(), communityPermissions, guestPermissions);
    }

    public void addEntryResources(long entryId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, addCommunityPermissions, addGuestPermissions);
    }

    public void addEntryResources(long entryId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, communityPermissions, guestPermissions);
    }

    public void deleteEntries(long folderId) throws PortalException, SystemException {
        for (BookmarksEntry entry : this.bookmarksEntryPersistence.findByFolderId(folderId)) {
            this.deleteEntry(entry);
        }
    }

    public void deleteEntry(BookmarksEntry entry) throws PortalException, SystemException {
        this.bookmarksEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource(entry.getCompanyId(), BookmarksEntry.class.getName(), 4, entry.getEntryId());
        this.expandoValueLocalService.deleteValues(BookmarksEntry.class.getName(), entry.getEntryId());
        this.tagsAssetLocalService.deleteAsset(BookmarksEntry.class.getName(), entry.getEntryId());
        try {
            Indexer.deleteEntry(entry.getCompanyId(), entry.getEntryId());
        }
        catch (SearchException se) {
            _log.error((Object)("Deleting index " + entry.getEntryId()), (Throwable)se);
        }
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public List<BookmarksEntry> getEntries(long folderId, int start, int end) throws SystemException {
        return this.bookmarksEntryPersistence.findByFolderId(folderId, start, end);
    }

    public List<BookmarksEntry> getEntries(long folderId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.bookmarksEntryPersistence.findByFolderId(folderId, start, end, orderByComparator);
    }

    public int getEntriesCount(long folderId) throws SystemException {
        return this.bookmarksEntryPersistence.countByFolderId(folderId);
    }

    public BookmarksEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
    }

    public int getFoldersEntriesCount(List<Long> folderIds) throws SystemException {
        return this.bookmarksEntryFinder.countByFolderIds(folderIds);
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, int start, int end) throws SystemException {
        return this.bookmarksEntryPersistence.findByGroupId(groupId, start, end, (OrderByComparator)new EntryModifiedDateComparator());
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, long userId, int start, int end) throws SystemException {
        EntryModifiedDateComparator orderByComparator = new EntryModifiedDateComparator();
        if (userId <= 0L) {
            return this.bookmarksEntryPersistence.findByGroupId(groupId, start, end, (OrderByComparator)orderByComparator);
        }
        return this.bookmarksEntryPersistence.findByG_U(groupId, userId, start, end, (OrderByComparator)orderByComparator);
    }

    public int getGroupEntriesCount(long groupId) throws SystemException {
        return this.bookmarksEntryPersistence.countByGroupId(groupId);
    }

    public int getGroupEntriesCount(long groupId, long userId) throws SystemException {
        if (userId <= 0L) {
            return this.bookmarksEntryPersistence.countByGroupId(groupId);
        }
        return this.bookmarksEntryPersistence.countByG_U(groupId, userId);
    }

    public List<BookmarksEntry> getNoAssetEntries() throws SystemException {
        return this.bookmarksEntryFinder.findByNoAssets();
    }

    public BookmarksEntry openEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        entry.setVisits(entry.getVisits() + 1);
        this.bookmarksEntryPersistence.update((BaseModel)entry, false);
        this.tagsAssetLocalService.incrementViewCounter(BookmarksEntry.class.getName(), entryId);
        return entry;
    }

    public void reIndex(BookmarksEntry entry) throws SystemException {
        long companyId = entry.getCompanyId();
        long groupId = entry.getGroupId();
        long folderId = entry.getFolderId();
        long entryId = entry.getEntryId();
        String name = entry.getName();
        String url = entry.getUrl();
        String comments = entry.getComments();
        Date modifiedDate = entry.getModifiedDate();
        String[] tagsEntries = this.tagsEntryLocalService.getEntryNames(BookmarksEntry.class.getName(), entryId);
        ExpandoBridge expandoBridge = entry.getExpandoBridge();
        try {
            Indexer.updateEntry(companyId, groupId, folderId, entryId, name, url, comments, modifiedDate, tagsEntries, expandoBridge);
        }
        catch (SearchException se) {
            _log.error((Object)("Reindexing " + entryId), (Throwable)se);
        }
    }

    public void reIndex(long entryId) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        BookmarksEntry entry = this.bookmarksEntryPersistence.fetchByPrimaryKey(entryId);
        if (entry == null) {
            return;
        }
        this.reIndex(entry);
    }

    public BookmarksEntry updateEntry(long userId, long entryId, long folderId, String name, String url, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        BookmarksFolder folder = this.getFolder(entry, folderId);
        if (Validator.isNull((String)name)) {
            name = url;
        }
        this.validate(url);
        entry.setModifiedDate(new Date());
        entry.setFolderId(folder.getFolderId());
        entry.setName(name);
        entry.setUrl(url);
        entry.setComments(comments);
        entry.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksEntryPersistence.update((BaseModel)entry, false);
        this.updateTagsAsset(userId, entry, serviceContext.getTagsEntries());
        this.reIndex(entry);
        return entry;
    }

    public void updateTagsAsset(long userId, BookmarksEntry entry, String[] tagsEntries) throws PortalException, SystemException {
        this.tagsAssetLocalService.updateAsset(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entry.getEntryId(), null, tagsEntries, true, null, null, null, null, "text/plain", entry.getName(), entry.getComments(), null, entry.getUrl(), 0, 0, null, false);
    }

    protected BookmarksFolder getFolder(BookmarksEntry entry, long folderId) throws PortalException, SystemException {
        if (entry.getFolderId() != folderId) {
            BookmarksFolder oldFolder = this.bookmarksFolderPersistence.findByPrimaryKey(entry.getFolderId());
            BookmarksFolder newFolder = this.bookmarksFolderPersistence.fetchByPrimaryKey(folderId);
            if (newFolder == null || oldFolder.getGroupId() != newFolder.getGroupId()) {
                folderId = entry.getFolderId();
            }
        }
        return this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
    }

    protected void validate(String url) throws PortalException {
        if (Validator.isNull((String)url)) {
            throw new EntryURLException();
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException murle) {
            throw new EntryURLException();
        }
    }
}

