/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.FolderNameException;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.base.BookmarksFolderLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksFolderLocalServiceImpl
extends BookmarksFolderLocalServiceBaseImpl {
    public BookmarksFolder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addFolder(null, userId, parentFolderId, name, description, serviceContext);
    }

    public BookmarksFolder addFolder(String uuid, long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        Date now = new Date();
        this.validate(name);
        long folderId = this.counterLocalService.increment();
        BookmarksFolder folder = this.bookmarksFolderPersistence.create(folderId);
        folder.setUuid(uuid);
        folder.setGroupId(groupId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setCreateDate(now);
        folder.setModifiedDate(now);
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksFolderPersistence.update((BaseModel)folder, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addFolderResources(folder, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addFolderResources(folder, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        return folder;
    }

    public void addFolderResources(BookmarksFolder folder, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), BookmarksFolder.class.getName(), folder.getFolderId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(BookmarksFolder folder, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), BookmarksFolder.class.getName(), folder.getFolderId(), communityPermissions, guestPermissions);
    }

    public void addFolderResources(long folderId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(long folderId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, communityPermissions, guestPermissions);
    }

    public void deleteFolder(BookmarksFolder folder) throws PortalException, SystemException {
        this.bookmarksFolderPersistence.remove((BaseModel)folder);
        this.resourceLocalService.deleteResource(folder.getCompanyId(), BookmarksFolder.class.getName(), 4, folder.getFolderId());
        this.bookmarksEntryLocalService.deleteEntries(folder.getFolderId());
        List folders = this.bookmarksFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId());
        for (BookmarksFolder curFolder : folders) {
            this.deleteFolder(curFolder);
        }
        this.expandoValueLocalService.deleteValues(BookmarksFolder.class.getName(), folder.getFolderId());
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        this.deleteFolder(folder);
    }

    public void deleteFolders(long groupId) throws PortalException, SystemException {
        List folders = this.bookmarksFolderPersistence.findByG_P(groupId, 0L);
        for (BookmarksFolder folder : folders) {
            this.deleteFolder(folder);
        }
    }

    public BookmarksFolder getFolder(long folderId) throws PortalException, SystemException {
        return this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.bookmarksFolderPersistence.findByG_P(groupId, parentFolderId, start, end);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.bookmarksFolderPersistence.countByG_P(groupId, parentFolderId);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List folders = this.bookmarksFolderPersistence.findByG_P(groupId, folderId);
        for (BookmarksFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    public void reIndex(String[] ids) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        long companyId = GetterUtil.getLong((String)ids[0]);
        try {
            this.reIndexFolders(companyId);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Hits search(long companyId, long groupId, long userId, long[] folderIds, String keywords, int start, int end) throws SystemException {
        try {
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            contextQuery.addRequiredTerm("portletId", "28");
            if (groupId > 0L) {
                Group group = this.groupLocalService.getGroup(groupId);
                if (group.isLayout()) {
                    contextQuery.addRequiredTerm("scopeGroupId", groupId);
                    groupId = group.getParentGroupId();
                }
                contextQuery.addRequiredTerm("groupId", groupId);
            }
            if (folderIds != null && folderIds.length > 0) {
                BooleanQuery folderIdsQuery = BooleanQueryFactoryUtil.create();
                for (long folderId : folderIds) {
                    if (userId > 0L) {
                        try {
                            this.bookmarksFolderService.getFolder(folderId);
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    TermQuery termQuery = TermQueryFactoryUtil.create((String)"folderId", (long)folderId);
                    folderIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
                }
                contextQuery.add((Query)folderIdsQuery, BooleanClauseOccur.MUST);
            }
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            if (Validator.isNotNull((String)keywords)) {
                searchQuery.addTerm("title", keywords);
                searchQuery.addTerm("tagsEntries", keywords, true);
                searchQuery.addTerm("url", keywords);
                searchQuery.addTerm("comments", keywords);
            }
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (searchQuery.clauses().size() > 0) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)companyId, (long)groupId, (long)userId, (String)BookmarksEntry.class.getName(), (Query)fullQuery, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public BookmarksFolder updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        this.validate(name);
        folder.setModifiedDate(new Date());
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksFolderPersistence.update((BaseModel)folder, false);
        if (mergeWithParentFolder && folderId != parentFolderId && parentFolderId != 0L) {
            this.mergeFolders(folder, parentFolderId);
        }
        return folder;
    }

    protected long getParentFolderId(BookmarksFolder folder, long parentFolderId) throws SystemException {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (folder.getFolderId() == parentFolderId) {
            return folder.getParentFolderId();
        }
        BookmarksFolder parentFolder = this.bookmarksFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null || folder.getGroupId() != parentFolder.getGroupId()) {
            return folder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return folder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) throws SystemException {
        BookmarksFolder parentFolder;
        if (parentFolderId != 0L && ((parentFolder = this.bookmarksFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void mergeFolders(BookmarksFolder fromFolder, long toFolderId) throws PortalException, SystemException {
        List folders = this.bookmarksFolderPersistence.findByG_P(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (BookmarksFolder folder : folders) {
            this.mergeFolders(folder, toFolderId);
        }
        List entries = this.bookmarksEntryPersistence.findByFolderId(fromFolder.getFolderId());
        for (BookmarksEntry entry : entries) {
            entry.setFolderId(toFolderId);
            this.bookmarksEntryPersistence.update((BaseModel)entry, false);
            this.bookmarksEntryLocalService.reIndex(entry);
        }
        this.deleteFolder(fromFolder);
    }

    protected void reIndexEntries(long folderId, int entryStart, int entryEnd) throws SystemException {
        List entries = this.bookmarksEntryPersistence.findByFolderId(folderId, entryStart, entryEnd);
        for (BookmarksEntry entry : entries) {
            this.bookmarksEntryLocalService.reIndex(entry);
        }
    }

    protected void reIndexFolders(long companyId) throws SystemException {
        int folderCount = this.bookmarksFolderPersistence.countByCompanyId(companyId);
        int folderPages = folderCount / 1000;
        for (int i = 0; i <= folderPages; ++i) {
            int folderStart = i * 1000;
            int folderEnd = folderStart + 1000;
            this.reIndexFolders(companyId, folderStart, folderEnd);
        }
    }

    protected void reIndexFolders(long companyId, int folderStart, int folderEnd) throws SystemException {
        List folders = this.bookmarksFolderPersistence.findByCompanyId(companyId, folderStart, folderEnd);
        for (BookmarksFolder folder : folders) {
            long folderId = folder.getFolderId();
            int entryCount = this.bookmarksEntryPersistence.countByFolderId(folderId);
            int entryPages = entryCount / 1000;
            for (int i = 0; i <= entryPages; ++i) {
                int entryStart = i * 1000;
                int entryEnd = entryStart + 1000;
                this.reIndexEntries(folderId, entryStart, entryEnd);
            }
        }
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name) || name.indexOf("\\\\") != -1 || name.indexOf("//") != -1) {
            throw new FolderNameException();
        }
    }
}

