/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.base.BookmarksFolderServiceBaseImpl;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;

public class BookmarksFolderServiceImpl
extends BookmarksFolderServiceBaseImpl {
    public BookmarksFolder addFolder(long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentFolderId, "ADD_FOLDER");
        return this.bookmarksFolderLocalService.addFolder(this.getUserId(), parentFolderId, name, description, serviceContext);
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), folderId, "DELETE");
        this.bookmarksFolderLocalService.deleteFolder(folderId);
    }

    public BookmarksFolder getFolder(long folderId) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), folderId, "VIEW");
        return this.bookmarksFolderLocalService.getFolder(folderId);
    }

    public BookmarksFolder updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), folderId, "UPDATE");
        return this.bookmarksFolderLocalService.updateFolder(folderId, parentFolderId, name, description, mergeWithParentFolder, serviceContext);
    }
}

