/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;

public class BookmarksEntryPermission {
    public static void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        if (!BookmarksEntryPermission.contains(permissionChecker, entryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, BookmarksEntry entry, String actionId) throws PortalException, SystemException {
        if (!BookmarksEntryPermission.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)entryId);
        return BookmarksEntryPermission.contains(permissionChecker, entry, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, BookmarksEntry entry, String actionId) throws PortalException, SystemException {
        BookmarksFolder folder = entry.getFolder();
        if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE && !BookmarksFolderPermission.contains(permissionChecker, folder, "VIEW")) {
            return false;
        }
        if (permissionChecker.hasOwnerPermission(entry.getCompanyId(), BookmarksEntry.class.getName(), entry.getEntryId(), entry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(entry.getGroupId(), BookmarksEntry.class.getName(), entry.getEntryId(), actionId);
    }
}

