/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksPermission;

public class BookmarksFolderPermission {
    public static void check(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException, SystemException {
        if (!BookmarksFolderPermission.contains(permissionChecker, groupId, folderId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long folderId, String actionId) throws PortalException, SystemException {
        if (!BookmarksFolderPermission.contains(permissionChecker, folderId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, BookmarksFolder folder, String actionId) throws PortalException, SystemException {
        if (!BookmarksFolderPermission.contains(permissionChecker, folder, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException, SystemException {
        if (folderId == 0L) {
            return BookmarksPermission.contains(permissionChecker, groupId, actionId);
        }
        return BookmarksFolderPermission.contains(permissionChecker, folderId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long folderId, String actionId) throws PortalException, SystemException {
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)folderId);
        return BookmarksFolderPermission.contains(permissionChecker, folder, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, BookmarksFolder folder, String actionId) throws PortalException, SystemException {
        if (actionId.equals("ADD_FOLDER")) {
            actionId = "ADD_SUBFOLDER";
        }
        long folderId = folder.getFolderId();
        if (actionId.equals("VIEW")) {
            while (folderId != 0L) {
                folder = BookmarksFolderLocalServiceUtil.getFolder((long)folderId);
                folderId = folder.getParentFolderId();
                if (!permissionChecker.hasOwnerPermission(folder.getCompanyId(), BookmarksFolder.class.getName(), folder.getFolderId(), folder.getUserId(), actionId) && !permissionChecker.hasPermission(folder.getGroupId(), BookmarksFolder.class.getName(), folder.getFolderId(), actionId)) {
                    return false;
                }
                if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) continue;
            }
            return true;
        }
        while (folderId != 0L) {
            if (permissionChecker.hasOwnerPermission(folder.getCompanyId(), BookmarksFolder.class.getName(), folder.getFolderId(), folder.getUserId(), actionId)) {
                return true;
            }
            if (permissionChecker.hasPermission(folder.getGroupId(), BookmarksFolder.class.getName(), folder.getFolderId(), actionId)) {
                return true;
            }
            if (actionId.equals("VIEW")) break;
            folder = BookmarksFolderLocalServiceUtil.getFolder((long)folderId);
            folderId = folder.getParentFolderId();
        }
        return false;
    }
}

