/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.util.comparator.EntryCreateDateComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryModifiedDateComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryNameComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryPriorityComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryURLComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryVisitsComparator;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.jsp.PageContext;

public class BookmarksUtil {
    public static String getBreadcrumbs(long folderId, long entryId, PageContext pageContext, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        if (entryId > 0L) {
            BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)entryId);
            return BookmarksUtil.getBreadcrumbs(entry.getFolder(), entry, pageContext, renderRequest, renderResponse);
        }
        BookmarksFolder folder = null;
        try {
            folder = BookmarksFolderLocalServiceUtil.getFolder((long)folderId);
        }
        catch (Exception e) {
            // empty catch block
        }
        return BookmarksUtil.getBreadcrumbs(folder, null, pageContext, renderRequest, renderResponse);
    }

    public static String getBreadcrumbs(BookmarksFolder folder, BookmarksEntry entry, PageContext pageContext, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString((PortletRequest)renderRequest, (String)"struts_action");
        boolean selectFolder = strutsAction.equals("/bookmarks/select_folder");
        if (entry != null && folder == null) {
            folder = entry.getFolder();
        }
        PortletURL foldersURL = renderResponse.createRenderURL();
        if (selectFolder) {
            foldersURL.setWindowState(LiferayWindowState.POP_UP);
            foldersURL.setParameter("struts_action", "/bookmarks/select_folder");
        } else {
            foldersURL.setParameter("struts_action", "/bookmarks/view");
        }
        String foldersLink = "<a href=\"" + foldersURL.toString() + "\">" + LanguageUtil.get((PageContext)pageContext, (String)"folders") + "</a>";
        if (folder == null) {
            return "<span class=\"first last\">" + foldersLink + "</span>";
        }
        String breadcrumbs = "";
        if (folder != null) {
            int i = 0;
            while (true) {
                folder = folder.toEscapedModel();
                PortletURL portletURL = renderResponse.createRenderURL();
                if (selectFolder) {
                    portletURL.setWindowState(LiferayWindowState.POP_UP);
                    portletURL.setParameter("struts_action", "/bookmarks/select_folder");
                    portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
                } else {
                    portletURL.setParameter("struts_action", "/bookmarks/view");
                    portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
                }
                String folderLink = "<a href=\"" + portletURL.toString() + "\">" + folder.getName() + "</a>";
                breadcrumbs = i == 0 ? (entry != null ? breadcrumbs + folderLink : "<span class=\"last\">" + folderLink + "</span>") : folderLink + " &raquo; " + breadcrumbs;
                if (folder.isRoot()) break;
                folder = BookmarksFolderLocalServiceUtil.getFolder((long)folder.getParentFolderId());
                ++i;
            }
        }
        breadcrumbs = "<span class=\"first\">" + foldersLink + " &raquo; </span>" + breadcrumbs;
        if (entry != null) {
            entry = entry.toEscapedModel();
            PortletURL entryURL = renderResponse.createRenderURL();
            entryURL.setParameter("struts_action", "/bookmarks/edit_entry");
            entryURL.setParameter("entryId", String.valueOf(entry.getEntryId()));
            String entryLink = "<span class=\"last\"><a href=\"" + entryURL.toString() + "\">" + entry.getEntryId() + "</a></span>";
            breadcrumbs = breadcrumbs + " &raquo; " + entryLink;
        }
        return breadcrumbs;
    }

    public static OrderByComparator getEntriesOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        EntryCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new EntryCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new EntryModifiedDateComparator(orderByAsc);
        } else if (orderByCol.equals("name")) {
            orderByComparator = new EntryNameComparator(orderByAsc);
        } else if (orderByCol.equals("priority")) {
            orderByComparator = new EntryPriorityComparator(orderByAsc);
        } else if (orderByCol.equals("url")) {
            orderByComparator = new EntryURLComparator(orderByAsc);
        } else if (orderByCol.equals("visits")) {
            orderByComparator = new EntryVisitsComparator(orderByAsc);
        }
        return orderByComparator;
    }
}

