/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.DocumentSummary;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import java.util.Date;
import javax.portlet.PortletURL;

public class Indexer
implements com.liferay.portal.kernel.search.Indexer {
    public static final String PORTLET_ID = "28";
    private static final String[] _CLASS_NAMES = new String[]{BookmarksEntry.class.getName()};

    public static void addEntry(long companyId, long groupId, long folderId, long entryId, String name, String url, String comments, Date modifiedDate, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getEntryDocument(companyId, groupId, folderId, entryId, name, url, comments, modifiedDate, tagsEntries, expandoBridge);
        SearchEngineUtil.addDocument((long)companyId, (Document)doc);
    }

    public static void deleteEntry(long companyId, long entryId) throws SearchException {
        SearchEngineUtil.deleteDocument((long)companyId, (String)Indexer.getEntryUID(entryId));
    }

    public static Document getEntryDocument(long companyId, long groupId, long folderId, long entryId, String name, String url, String comments, Date modifiedDate, String[] tagsEntries, ExpandoBridge expandoBridge) {
        long scopeGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                groupId = group.getParentGroupId();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, entryId);
        doc.addModifiedDate(modifiedDate);
        doc.addKeyword("companyId", companyId);
        doc.addKeyword("portletId", PORTLET_ID);
        doc.addKeyword("groupId", groupId);
        doc.addKeyword("scopeGroupId", scopeGroupId);
        doc.addText("title", name);
        doc.addKeyword("tagsEntries", tagsEntries);
        doc.addKeyword("folderId", folderId);
        doc.addKeyword("entryClassName", BookmarksEntry.class.getName());
        doc.addKeyword("entryClassPK", entryId);
        doc.addText("url", url);
        doc.addText("comments", comments);
        ExpandoBridgeIndexerUtil.addAttributes((Document)doc, (ExpandoBridge)expandoBridge);
        return doc;
    }

    public static String getEntryUID(long entryId) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, entryId);
        return doc.get("uid");
    }

    public static void updateEntry(long companyId, long groupId, long folderId, long entryId, String name, String url, String comments, Date modifiedDate, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getEntryDocument(companyId, groupId, folderId, entryId, name, url, comments, modifiedDate, tagsEntries, expandoBridge);
        SearchEngineUtil.updateDocument((long)companyId, (String)doc.get("uid"), (Document)doc);
    }

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    public DocumentSummary getDocumentSummary(Document doc, String snippet, PortletURL portletURL) {
        String title = doc.get("title");
        String url = doc.get("url");
        String entryId = doc.get("entryClassPK");
        portletURL.setParameter("struts_action", "/bookmarks/edit_entry");
        portletURL.setParameter("entryId", entryId);
        return new DocumentSummary(title, url, portletURL);
    }

    public void reIndex(String className, long classPK) throws SearchException {
        try {
            BookmarksEntryLocalServiceUtil.reIndex((long)classPK);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void reIndex(String[] ids) throws SearchException {
        try {
            BookmarksFolderLocalServiceUtil.reIndex((String[])ids);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }
}

